/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.service;

import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.service.ExportImportConfigurationLocalService;
import com.liferay.exportimport.kernel.service.ExportImportConfigurationLocalServiceWrapper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.ServiceWrapper;
import com.liferay.trash.exception.RestoreEntryException;
import com.liferay.trash.exception.TrashEntryException;
import com.liferay.trash.model.TrashEntry;
import com.liferay.trash.service.TrashEntryLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ServiceWrapper.class})
public class TrashEntryExportImportConfigurationLocalServiceWrapper
extends ExportImportConfigurationLocalServiceWrapper {
    @Reference
    private ExportImportConfigurationLocalService _exportImportConfigurationLocalService;
    @Reference
    private TrashEntryLocalService _trashEntryLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public ExportImportConfiguration moveExportImportConfigurationToTrash(long userId, long exportImportConfigurationId) throws PortalException {
        ExportImportConfiguration exportImportConfiguration = this._exportImportConfigurationLocalService.getExportImportConfiguration(exportImportConfigurationId);
        if (exportImportConfiguration.isInTrash()) {
            throw new TrashEntryException();
        }
        int oldStatus = exportImportConfiguration.getStatus();
        exportImportConfiguration = this.updateStatus(userId, exportImportConfiguration.getExportImportConfigurationId(), 8);
        this._trashEntryLocalService.addTrashEntry(userId, exportImportConfiguration.getGroupId(), ExportImportConfiguration.class.getName(), exportImportConfiguration.getExportImportConfigurationId(), null, null, oldStatus, null, null);
        return exportImportConfiguration;
    }

    @Indexable(type=IndexableType.REINDEX)
    public ExportImportConfiguration restoreExportImportConfigurationFromTrash(long userId, long exportImportConfigurationId) throws PortalException {
        ExportImportConfiguration exportImportConfiguration = this._exportImportConfigurationLocalService.getExportImportConfiguration(exportImportConfigurationId);
        if (!exportImportConfiguration.isInTrash()) {
            throw new RestoreEntryException(4);
        }
        TrashEntry trashEntry = this._trashEntryLocalService.getEntry(ExportImportConfiguration.class.getName(), exportImportConfigurationId);
        exportImportConfiguration = this.updateStatus(userId, exportImportConfiguration.getExportImportConfigurationId(), trashEntry.getStatus());
        this._trashEntryLocalService.deleteEntry(ExportImportConfiguration.class.getName(), exportImportConfiguration.getExportImportConfigurationId());
        return exportImportConfiguration;
    }
}

