/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.staged.model.repository;

import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.exportimport.staged.model.repository.StagedModelRepositoryHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.StagedGroupedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.model.TrashedModel;
import com.liferay.portal.kernel.service.GroupLocalService;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={StagedModelRepositoryHelper.class})
public class StagedModelRepositoryHelperImpl
implements StagedModelRepositoryHelper {
    private static final Log _log = LogFactoryUtil.getLog(StagedModelRepositoryHelperImpl.class);
    @Reference
    private GroupLocalService _groupLocalService;

    public <T extends StagedModel> T fetchMissingReference(String uuid, long groupId, StagedModelRepository<T> stagedModelRepository) {
        block9: {
            StagedModel existingStagedModel = stagedModelRepository.fetchStagedModelByUuidAndGroupId(uuid, groupId);
            if (existingStagedModel != null && !this.isStagedModelInTrash(existingStagedModel)) {
                return (T)existingStagedModel;
            }
            try {
                Group group;
                Group originalGroup = this._groupLocalService.getGroup(groupId);
                for (group = originalGroup.getParentGroup(); group != null && (existingStagedModel = stagedModelRepository.fetchStagedModelByUuidAndGroupId(uuid, group.getGroupId())) == null; group = group.getParentGroup()) {
                }
                if (existingStagedModel != null && !this.isStagedModelInTrash(existingStagedModel)) {
                    return (T)existingStagedModel;
                }
                List existingStagedModels = stagedModelRepository.fetchStagedModelsByUuidAndCompanyId(uuid, originalGroup.getCompanyId());
                for (StagedModel stagedModel : existingStagedModels) {
                    try {
                        StagedGroupedModel stagedGroupedModel;
                        if (!(stagedModel instanceof StagedGroupedModel ? !(group = this._groupLocalService.getGroup((stagedGroupedModel = (StagedGroupedModel)stagedModel).getGroupId())).isStagingGroup() && !this.isStagedModelInTrash(stagedModel) : !this.isStagedModelInTrash(stagedModel))) continue;
                        return (T)stagedModel;
                    }
                    catch (PortalException portalException) {
                        if (!_log.isDebugEnabled()) continue;
                        _log.debug((Throwable)portalException);
                    }
                }
            }
            catch (Exception exception) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)exception);
                }
                if (!_log.isWarnEnabled()) break block9;
                _log.warn((Object)("Unable to fetch missing reference staged model from group " + groupId));
            }
        }
        return null;
    }

    public boolean isStagedModelInTrash(StagedModel stagedModel) {
        if (!(stagedModel instanceof TrashedModel)) {
            return false;
        }
        TrashedModel trashedModel = (TrashedModel)stagedModel;
        return trashedModel.isInTrash();
    }
}

