/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.search.spi.model.index.contributor;

import com.liferay.exportimport.kernel.lar.ExportImportHelper;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import java.io.Serializable;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"indexer.class.name=com.liferay.exportimport.kernel.model.ExportImportConfiguration"}, service={ModelDocumentContributor.class})
public class ExportImportConfigurationModelDocumentContributor
implements ModelDocumentContributor<ExportImportConfiguration> {
    private static final String _PREFIX_PARAMETER = "parameter_";
    private static final String _PREFIX_SETTING = "setting_";
    private static final Log _log = LogFactoryUtil.getLog(ExportImportConfigurationModelDocumentContributor.class);
    @Reference
    private ExportImportHelper _exportImportHelper;

    public void contribute(Document document, ExportImportConfiguration exportImportConfiguration) {
        document.addText("description", exportImportConfiguration.getDescription());
        document.addText("name", exportImportConfiguration.getName());
        document.addKeyword("type", exportImportConfiguration.getType());
        document.addNumber("exportImportConfigurationId", exportImportConfiguration.getExportImportConfigurationId());
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        this.populateDates(document, settingsMap);
        this.populateLayoutIds(document, settingsMap);
        this.populateLocale(document, settingsMap);
        this.populateParameterMap(document, settingsMap);
        this.populateSiteInformation(document, settingsMap);
        this.populateTimeZone(document, settingsMap);
        document.addKeyword("setting_userId", MapUtil.getLong((Map)settingsMap, (String)"userId"));
    }

    protected void populateDates(Document document, Map<String, Serializable> settingsMap) {
        if (settingsMap.containsKey("endDate")) {
            Date endDate = (Date)settingsMap.get("endDate");
            document.addDate("setting_endDate", endDate);
        }
        if (settingsMap.containsKey("startDate")) {
            Date startDate = (Date)settingsMap.get("startDate");
            document.addDate("setting_startDate", startDate);
        }
    }

    protected void populateLayoutIds(Document document, Map<String, Serializable> settingsMap) {
        long[] layoutIds;
        block4: {
            if (!settingsMap.containsKey("layoutIdMap") && !settingsMap.containsKey("layoutIds")) {
                return;
            }
            layoutIds = GetterUtil.getLongValues((Object)settingsMap.get("layoutIds"));
            if (ArrayUtil.isEmpty((long[])layoutIds)) {
                Map layoutIdMap = (Map)((Object)settingsMap.get("layoutIdMap"));
                try {
                    layoutIds = this._exportImportHelper.getLayoutIds(layoutIdMap);
                }
                catch (PortalException portalException) {
                    if (!_log.isDebugEnabled()) break block4;
                    _log.debug((Object)portalException, (Throwable)portalException);
                }
            }
        }
        document.addKeyword("layoutIds", layoutIds);
    }

    protected void populateLocale(Document document, Map<String, Serializable> settingsMap) {
        Locale locale = (Locale)settingsMap.get("locale");
        document.addText("setting_locale", locale.toString());
    }

    protected void populateParameterMap(Document document, Map<String, Serializable> settingsMap) {
        if (!settingsMap.containsKey("parameterMap")) {
            return;
        }
        Map parameterMap = (Map)((Object)settingsMap.get("parameterMap"));
        for (Map.Entry entry : parameterMap.entrySet()) {
            String parameterName = (String)entry.getKey();
            if (!Field.validateFieldName((String)parameterName)) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Skipping invalid parameter name: " + parameterName));
                continue;
            }
            String[] parameterValues = (String[])ArrayUtil.clone((Object[])((Object[])entry.getValue()));
            for (int i = 0; i < parameterValues.length; ++i) {
                String parameterValue = parameterValues[i];
                if (parameterValue.equals("true")) {
                    parameterValues[i] = "on";
                    continue;
                }
                if (!parameterValue.equals("false")) continue;
                parameterValues[i] = "off";
            }
            document.addKeyword(_PREFIX_PARAMETER + (String)entry.getKey(), parameterValues);
        }
    }

    protected void populateSiteInformation(Document document, Map<String, Serializable> settingsMap) {
        document.addKeyword("setting_privateLayout", MapUtil.getBoolean(settingsMap, (String)"privateLayout"));
        document.addKeyword("setting_sourceGroupId", MapUtil.getLong(settingsMap, (String)"sourceGroupId"));
        document.addKeyword("setting_targetGroupId", MapUtil.getLong(settingsMap, (String)"targetGroupId"));
    }

    protected void populateTimeZone(Document document, Map<String, Serializable> settingsMap) {
        TimeZone timeZone = (TimeZone)settingsMap.get("timeZone");
        if (timeZone != null) {
            document.addKeyword("setting_timeZone", timeZone.getDisplayName());
        }
    }
}

