/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.portlet.data.handler.provider;

import com.liferay.exportimport.kernel.lar.PortletDataHandler;
import com.liferay.exportimport.portlet.data.handler.provider.PortletDataHandlerProvider;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.util.Validator;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={PortletDataHandlerProvider.class})
public class PortletDataHandlerProviderImpl
implements PortletDataHandlerProvider {
    @Reference
    private PortletLocalService _portletLocalService;

    public PortletDataHandler provide(long companyId, String portletId) {
        if (companyId <= 0L || Validator.isNull((String)portletId)) {
            return null;
        }
        Portlet portlet = this._portletLocalService.getPortletById(companyId, portletId);
        return this.doProvide(portlet);
    }

    public PortletDataHandler provide(Portlet portlet) {
        return this.doProvide(portlet);
    }

    public PortletDataHandler provide(String portletId) {
        if (Validator.isNull((String)portletId)) {
            return null;
        }
        Portlet portlet = this._portletLocalService.getPortletById(portletId);
        return this.doProvide(portlet);
    }

    protected PortletDataHandler doProvide(Portlet portlet) {
        if (portlet == null || !portlet.isActive() || portlet.isUndeployedPortlet()) {
            return null;
        }
        try {
            return portlet.getPortletDataHandlerInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

