/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.background.task;

import com.liferay.exportimport.internal.background.task.BaseExportImportBackgroundTaskExecutor;
import com.liferay.exportimport.internal.background.task.LayoutExportImportBackgroundTaskStatusMessageTranslator;
import com.liferay.exportimport.kernel.exception.ExportImportIOException;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.service.ExportImportLocalServiceUtil;
import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutor;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskResult;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.Callable;

public class LayoutImportBackgroundTaskExecutor
extends BaseExportImportBackgroundTaskExecutor {
    public LayoutImportBackgroundTaskExecutor() {
        this.setBackgroundTaskStatusMessageTranslator(new LayoutExportImportBackgroundTaskStatusMessageTranslator());
        this.setIsolationLevel(3);
    }

    public BackgroundTaskExecutor clone() {
        LayoutImportBackgroundTaskExecutor layoutImportBackgroundTaskExecutor = new LayoutImportBackgroundTaskExecutor();
        layoutImportBackgroundTaskExecutor.setBackgroundTaskStatusMessageTranslator(this.getBackgroundTaskStatusMessageTranslator());
        layoutImportBackgroundTaskExecutor.setIsolationLevel(this.getIsolationLevel());
        return layoutImportBackgroundTaskExecutor;
    }

    public BackgroundTaskResult execute(BackgroundTask backgroundTask) throws Exception {
        ExportImportConfiguration exportImportConfiguration = this.getExportImportConfiguration(backgroundTask);
        List attachmentsFileEntries = backgroundTask.getAttachmentsFileEntries();
        File file = null;
        for (FileEntry attachmentsFileEntry : attachmentsFileEntries) {
            try {
                file = FileUtil.createTempFile((String)"lar");
                FileUtil.write((File)file, (InputStream)attachmentsFileEntry.getContentStream());
                TransactionInvokerUtil.invoke((TransactionConfig)transactionConfig, (Callable)new LayoutImportCallable(exportImportConfiguration, file));
            }
            catch (IOException ioException) {
                ExportImportIOException exportImportIOException = new ExportImportIOException(LayoutImportBackgroundTaskExecutor.class.getName(), (Throwable)ioException);
                if (Validator.isNotNull((String)attachmentsFileEntry.getFileName())) {
                    exportImportIOException.setFileName(attachmentsFileEntry.getFileName());
                    exportImportIOException.setType(6);
                } else {
                    exportImportIOException.setType(5);
                }
                throw exportImportIOException;
            }
            catch (Throwable t) {
                throw new SystemException(t);
            }
            finally {
                FileUtil.delete((File)file);
            }
        }
        return BackgroundTaskResult.SUCCESS;
    }

    private static class LayoutImportCallable
    implements Callable<Void> {
        private final ExportImportConfiguration _exportImportConfiguration;
        private final File _file;

        public LayoutImportCallable(ExportImportConfiguration exportImportConfiguration, File file) {
            this._exportImportConfiguration = exportImportConfiguration;
            this._file = file;
        }

        @Override
        public Void call() throws PortalException {
            ExportImportLocalServiceUtil.importLayoutsDataDeletions((ExportImportConfiguration)this._exportImportConfiguration, (File)this._file);
            ExportImportLocalServiceUtil.importLayouts((ExportImportConfiguration)this._exportImportConfiguration, (File)this._file);
            return null;
        }
    }
}

