/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.lifecycle;

import com.liferay.exportimport.internal.lar.ExportImportProcessCallbackUtil;
import com.liferay.exportimport.kernel.lifecycle.ExportImportLifecycleEvent;
import com.liferay.exportimport.kernel.lifecycle.ExportImportLifecycleListener;
import com.liferay.exportimport.kernel.lifecycle.ProcessAwareExportImportLifecycleListener;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.List;
import java.util.concurrent.Callable;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={ExportImportLifecycleListener.class})
public class ExportImportProcessCallbackLifecycleListener
implements ProcessAwareExportImportLifecycleListener {
    private static final Log _log = LogFactoryUtil.getLog(ExportImportProcessCallbackLifecycleListener.class);

    public boolean isParallel() {
        return false;
    }

    public void onProcessFailed(ExportImportLifecycleEvent exportImportLifecycleEvent) throws Exception {
        ExportImportProcessCallbackUtil.popCallbackList(exportImportLifecycleEvent.getProcessId());
    }

    public void onProcessStarted(ExportImportLifecycleEvent exportImportLifecycleEvent) throws Exception {
        ExportImportProcessCallbackUtil.pushCallbackList(exportImportLifecycleEvent.getProcessId());
    }

    public void onProcessSucceeded(ExportImportLifecycleEvent exportImportLifecycleEvent) throws Exception {
        List<Callable<?>> callables = ExportImportProcessCallbackUtil.popCallbackList(exportImportLifecycleEvent.getProcessId());
        for (Callable<?> callable : callables) {
            try {
                callable.call();
            }
            catch (Exception e) {
                _log.error((Object)"Unable to execute export import process callback", (Throwable)e);
            }
        }
    }
}

