/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.service.impl;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.service.base.DDMStructureVersionServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=ddm", "json.web.service.context.path=DDMStructureVersion"}, service={AopService.class})
public class DDMStructureVersionServiceImpl
extends DDMStructureVersionServiceBaseImpl {
    @Reference(target="(model.class.name=com.liferay.dynamic.data.mapping.model.DDMStructure)")
    private ModelResourcePermission<DDMStructure> _ddmStructureModelResourcePermission;

    public DDMStructureVersion getLatestStructureVersion(long structureId) throws PortalException {
        this._ddmStructureModelResourcePermission.check(this.getPermissionChecker(), structureId, "VIEW");
        return this.ddmStructureVersionLocalService.getLatestStructureVersion(structureId);
    }

    public DDMStructureVersion getStructureVersion(long structureVersionId) throws PortalException {
        DDMStructureVersion structureVersion = this.ddmStructureVersionLocalService.getStructureVersion(structureVersionId);
        this._ddmStructureModelResourcePermission.check(this.getPermissionChecker(), structureVersion.getStructureId(), "VIEW");
        return structureVersion;
    }

    public List<DDMStructureVersion> getStructureVersions(long structureId, int start, int end, OrderByComparator<DDMStructureVersion> orderByComparator) throws PortalException {
        this._ddmStructureModelResourcePermission.check(this.getPermissionChecker(), structureId, "VIEW");
        return this.ddmStructureVersionLocalService.getStructureVersions(structureId, start, end, orderByComparator);
    }

    public int getStructureVersionsCount(long structureId) throws PortalException {
        this._ddmStructureModelResourcePermission.check(this.getPermissionChecker(), structureId, "VIEW");
        return this.ddmStructureVersionLocalService.getStructureVersionsCount(structureId);
    }
}

