/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v2_0_3;

import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.PortalUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class DDMFormInstanceDefinitionUpgradeProcess
extends UpgradeProcess {
    private final JSONFactory _jsonFactory;

    public DDMFormInstanceDefinitionUpgradeProcess(JSONFactory jsonFactory) {
        this._jsonFactory = jsonFactory;
    }

    protected void doUpgrade() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select structureId, definition from DDMStructure where classNameId = ?");
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructure set definition = ? where structureId = ?");){
            preparedStatement1.setLong(1, PortalUtil.getClassNameId(DDMFormInstance.class));
            try (ResultSet resultSet = preparedStatement1.executeQuery();){
                while (resultSet.next()) {
                    String definition = resultSet.getString("definition");
                    preparedStatement2.setString(1, this._updateFieldsToLocalizable(definition));
                    long structureId = resultSet.getLong("structureId");
                    preparedStatement2.setLong(2, structureId);
                    preparedStatement2.addBatch();
                }
            }
            preparedStatement2.executeBatch();
        }
    }

    private void _updateFieldsToLocalizable(JSONArray fieldsJSONArray) {
        for (int i = 0; i < fieldsJSONArray.length(); ++i) {
            JSONObject fieldJSONObject = fieldsJSONArray.getJSONObject(i);
            fieldJSONObject.put("localizable", true);
            JSONArray nestedFieldsJSONArray = fieldJSONObject.getJSONArray("nestedFields");
            if (nestedFieldsJSONArray == null) continue;
            this._updateFieldsToLocalizable(nestedFieldsJSONArray);
        }
    }

    private String _updateFieldsToLocalizable(String definition) throws PortalException {
        JSONObject ddmFormJSONObject = this._jsonFactory.createJSONObject(definition);
        JSONArray fieldsJSONArray = ddmFormJSONObject.getJSONArray("fields");
        this._updateFieldsToLocalizable(fieldsJSONArray);
        return ddmFormJSONObject.toString();
    }
}

