/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.render;

import com.liferay.document.library.kernel.service.DLAppLocalServiceUtil;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.render.BaseDDMFormFieldValueRenderer;
import com.liferay.dynamic.data.mapping.render.ValueAccessor;
import com.liferay.dynamic.data.mapping.render.ValueAccessorException;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.Validator;
import java.util.Locale;

public class DocumentLibraryDDMFormFieldValueRenderer
extends BaseDDMFormFieldValueRenderer {
    private static final Log _log = LogFactoryUtil.getLog(DocumentLibraryDDMFormFieldValueRenderer.class);

    public String getSupportedDDMFormFieldType() {
        return "ddm-documentlibrary";
    }

    protected ValueAccessor getValueAccessor(Locale locale) {
        return new ValueAccessor(locale){

            public String get(DDMFormFieldValue ddmFormFieldValue) {
                Value value = ddmFormFieldValue.getValue();
                JSONObject jsonObject = this.createJSONObject(value.getString(this.locale));
                String uuid = jsonObject.getString("uuid");
                long groupId = jsonObject.getLong("groupId");
                if (Validator.isNull((String)uuid) && groupId == 0L) {
                    return "";
                }
                try {
                    FileEntry fileEntry = DLAppLocalServiceUtil.getFileEntryByUuidAndGroupId((String)uuid, (long)groupId);
                    return fileEntry.getTitle();
                }
                catch (Exception exception) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Throwable)exception);
                    }
                    return LanguageUtil.format((Locale)this.locale, (String)"is-temporarily-unavailable", (Object)"content");
                }
            }

            protected JSONObject createJSONObject(String json) {
                try {
                    return JSONFactoryUtil.createJSONObject((String)json);
                }
                catch (JSONException jsonException) {
                    throw new ValueAccessorException((Throwable)jsonException);
                }
            }
        };
    }
}

