/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v1_1_1;

import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class DDMStructureIndexTypeUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(DDMStructureIndexTypeUpgradeProcess.class);
    private final JSONFactory _jsonFactory;

    public DDMStructureIndexTypeUpgradeProcess(JSONFactory jsonFactory) {
        this._jsonFactory = jsonFactory;
    }

    protected void doUpgrade() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select DDMStructure.definition, DDMStructure.structureId from DDMStructure where structureKey = ? ");
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructure set definition = ? where structureId = ?");
             PreparedStatement preparedStatement3 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructureVersion set definition = ? where structureId = ?");){
            preparedStatement1.setString(1, "TIKARAWMETADATA");
            try (ResultSet resultSet = preparedStatement1.executeQuery();){
                while (resultSet.next()) {
                    String newDefinition = this._upgradeIndexType(resultSet.getString(1));
                    preparedStatement2.setString(1, newDefinition);
                    preparedStatement2.setLong(2, resultSet.getLong(2));
                    preparedStatement2.addBatch();
                    preparedStatement3.setString(1, newDefinition);
                    preparedStatement3.setLong(2, resultSet.getLong(2));
                    preparedStatement3.addBatch();
                }
                preparedStatement2.executeBatch();
                preparedStatement3.executeBatch();
            }
        }
    }

    private String _upgradeIndexType(String definition) throws PortalException {
        try {
            JSONObject definitionJSONObject = this._jsonFactory.createJSONObject(definition);
            JSONArray fieldsJSONArray = definitionJSONObject.getJSONArray("fields");
            for (int i = 0; i < fieldsJSONArray.length(); ++i) {
                JSONObject jsonObject = fieldsJSONArray.getJSONObject(i);
                if (jsonObject.has("indexType")) continue;
                jsonObject.put("indexType", "text");
            }
            return definitionJSONObject.toString();
        }
        catch (JSONException jsonException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)jsonException);
            }
            return definition;
        }
    }
}

