/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.io;

import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesRegistry;
import com.liferay.dynamic.data.mapping.internal.io.DDMFormRuleJSONDeserializer;
import com.liferay.dynamic.data.mapping.internal.io.util.DDMFormFieldDeserializerUtil;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializerDeserializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializerDeserializeResponse;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.DDMFormSuccessPageSettings;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"ddm.form.deserializer.type=json"}, service={DDMFormDeserializer.class})
public class DDMFormJSONDeserializer
implements DDMFormDeserializer {
    private static final Log _log = LogFactoryUtil.getLog(DDMFormJSONDeserializer.class);
    @Reference
    private DDMFormFieldTypeServicesRegistry _ddmFormFieldTypeServicesRegistry;
    @Reference
    private JSONFactory _jsonFactory;

    public DDMFormDeserializerDeserializeResponse deserialize(DDMFormDeserializerDeserializeRequest ddmFormDeserializerDeserializeRequest) {
        DDMForm ddmForm = new DDMForm();
        DDMFormDeserializerDeserializeResponse.Builder builder = DDMFormDeserializerDeserializeResponse.Builder.newBuilder((DDMForm)ddmForm);
        try {
            JSONObject jsonObject = this._jsonFactory.createJSONObject(ddmFormDeserializerDeserializeRequest.getContent());
            if (Validator.isNotNull((String)jsonObject.getString("definitionSchemaVersion"))) {
                ddmForm.setDefinitionSchemaVersion(jsonObject.getString("definitionSchemaVersion"));
            }
            this._setDDMFormAvailableLocales(jsonObject.getJSONArray("availableLanguageIds"), ddmForm);
            this._setDDMFormDefaultLocale(jsonObject.getString("defaultLanguageId"), ddmForm);
            this._setDDMFormFields(jsonObject.getJSONArray("fields"), ddmForm);
            this._setDDMFormLocalizedValuesDefaultLocale(ddmForm);
            this._setDDMFormRules(jsonObject.getJSONArray("rules"), ddmForm);
            this._setDDMFormSuccessPageSettings(jsonObject.getJSONObject("successPage"), ddmForm);
            return builder.build();
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)exception);
            }
            builder = builder.exception(exception);
            return builder.build();
        }
    }

    private LocalizedValue _deserializeLocalizedValue(String value, Locale defaultLocale) throws PortalException {
        LocalizedValue localizedValue = new LocalizedValue(defaultLocale);
        if (Validator.isNull((String)value)) {
            return localizedValue;
        }
        JSONObject jsonObject = this._jsonFactory.createJSONObject(value);
        Iterator iterator = jsonObject.keys();
        while (iterator.hasNext()) {
            String languageId = (String)iterator.next();
            localizedValue.addString(LocaleUtil.fromLanguageId((String)languageId), jsonObject.getString(languageId));
        }
        return localizedValue;
    }

    private void _setDDMFormAvailableLocales(JSONArray jsonArray, DDMForm ddmForm) {
        HashSet<Locale> availableLocales = new HashSet<Locale>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            Locale availableLocale = LocaleUtil.fromLanguageId((String)jsonArray.getString(i));
            availableLocales.add(availableLocale);
        }
        ddmForm.setAvailableLocales(availableLocales);
    }

    private void _setDDMFormDefaultLocale(String defaultLanguageId, DDMForm ddmForm) {
        ddmForm.setDefaultLocale(LocaleUtil.fromLanguageId((String)defaultLanguageId));
    }

    private void _setDDMFormFieldLocalizedValueDefaultLocale(LocalizedValue localizedValue, Locale defaultLocale) {
        if (localizedValue == null) {
            return;
        }
        localizedValue.setDefaultLocale(defaultLocale);
    }

    private void _setDDMFormFieldLocalizedValuesDefaultLocale(DDMFormField ddmFormField, Locale defaultLocale) {
        this._setDDMFormFieldLocalizedValueDefaultLocale(ddmFormField.getLabel(), defaultLocale);
        this._setDDMFormFieldLocalizedValueDefaultLocale(ddmFormField.getPredefinedValue(), defaultLocale);
        this._setDDMFormFieldLocalizedValueDefaultLocale(ddmFormField.getStyle(), defaultLocale);
        this._setDDMFormFieldLocalizedValueDefaultLocale(ddmFormField.getTip(), defaultLocale);
        DDMFormFieldOptions ddmFormFieldOptions = ddmFormField.getDDMFormFieldOptions();
        if (ddmFormFieldOptions != null) {
            ddmFormFieldOptions.setDefaultLocale(defaultLocale);
        }
        for (DDMFormField nestedDDMFormField : ddmFormField.getNestedDDMFormFields()) {
            this._setDDMFormFieldLocalizedValuesDefaultLocale(nestedDDMFormField, defaultLocale);
        }
    }

    private void _setDDMFormFields(JSONArray jsonArray, DDMForm ddmForm) throws PortalException {
        ddmForm.setDDMFormFields(DDMFormFieldDeserializerUtil.deserialize(this._ddmFormFieldTypeServicesRegistry, jsonArray, this._jsonFactory));
    }

    private void _setDDMFormLocalizedValuesDefaultLocale(DDMForm ddmForm) {
        for (DDMFormField ddmFormField : ddmForm.getDDMFormFields()) {
            this._setDDMFormFieldLocalizedValuesDefaultLocale(ddmFormField, ddmForm.getDefaultLocale());
        }
    }

    private void _setDDMFormRules(JSONArray jsonArray, DDMForm ddmForm) {
        if (jsonArray == null || jsonArray.length() == 0) {
            return;
        }
        ddmForm.setDDMFormRules(DDMFormRuleJSONDeserializer.deserialize(jsonArray));
    }

    private void _setDDMFormSuccessPageSettings(JSONObject jsonObject, DDMForm ddmForm) throws PortalException {
        if (jsonObject == null) {
            return;
        }
        Locale defaultLocale = ddmForm.getDefaultLocale();
        DDMFormSuccessPageSettings ddmFormSuccessPageSettings = new DDMFormSuccessPageSettings(this._deserializeLocalizedValue(jsonObject.getString("body"), defaultLocale), this._deserializeLocalizedValue(jsonObject.getString("title"), defaultLocale), jsonObject.getBoolean("enabled"));
        ddmForm.setDDMFormSuccessPageSettings(ddmFormSuccessPageSettings);
    }
}

