/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.util;

import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.Field;
import com.liferay.dynamic.data.mapping.storage.Fields;
import com.liferay.dynamic.data.mapping.storage.constants.FieldConstants;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesConverterUtil;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesToFieldsConverter;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;

@Component(service={DDMFormValuesToFieldsConverter.class})
public class DDMFormValuesToFieldsConverterImpl
implements DDMFormValuesToFieldsConverter {
    public Fields convert(DDMStructure ddmStructure, DDMFormValues ddmFormValues) throws PortalException {
        DDMForm ddmForm = ddmStructure.getFullHierarchyDDMForm(false);
        List ddmFormFieldValues = DDMFormValuesConverterUtil.addMissingDDMFormFieldValues((Collection)ddmForm.getDDMFormFields(), (Map)ddmFormValues.getDDMFormFieldValuesMap(true));
        Fields fields = new Fields();
        StringBundler fieldDisplayNamesSB = new StringBundler(ddmFormFieldValues.size() * 4);
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
            this._addFields(ddmForm, ddmFormFieldValue, ddmFormFieldValues, ddmStructure.getStructureId(), ddmFormValues.getDefaultLocale(), fieldDisplayNamesSB, fields);
        }
        if (!ddmFormFieldValues.isEmpty()) {
            fieldDisplayNamesSB.setIndex(fieldDisplayNamesSB.index() - 1);
        }
        fields.put(new Field(ddmStructure.getStructureId(), "_fieldsDisplay", (Serializable)((Object)fieldDisplayNamesSB.toString())));
        return fields;
    }

    private void _addField(DDMFormField ddmFormField, DDMFormFieldValue ddmFormFieldValue, List<DDMFormFieldValue> ddmFormFieldValues, long ddmStructureId, Locale defaultLocale, Fields fields) throws PortalException {
        if (ddmFormField == null || ddmFormField.isTransient() || ddmFormFieldValue.getValue() == null) {
            return;
        }
        Field field = this._createField(ddmFormField, ddmFormFieldValues, ddmFormFieldValue, ddmStructureId, defaultLocale);
        Field existingField = fields.get(field.getName());
        if (existingField == null) {
            fields.put(field);
            return;
        }
        for (Locale availableLocale : field.getAvailableLocales()) {
            existingField.addValues(availableLocale, field.getValues(availableLocale));
        }
    }

    private void _addFields(DDMForm ddmForm, DDMFormFieldValue ddmFormFieldValue, List<DDMFormFieldValue> ddmFormFieldValues, long ddmStructureId, Locale defaultLocale, StringBundler fieldDisplayNamesSB, Fields fields) throws PortalException {
        this._addField(ddmForm.getDDMFormField(ddmFormFieldValue.getName(), true), ddmFormFieldValue, ddmFormFieldValues, ddmStructureId, defaultLocale, fields);
        fieldDisplayNamesSB.append(ddmFormFieldValue.getName());
        fieldDisplayNamesSB.append("_INSTANCE_");
        fieldDisplayNamesSB.append(ddmFormFieldValue.getInstanceId());
        fieldDisplayNamesSB.append(",");
        for (DDMFormFieldValue nestedDDMFormFieldValue : ddmFormFieldValue.getNestedDDMFormFieldValues()) {
            this._addFields(ddmForm, nestedDDMFormFieldValue, ddmFormFieldValues, ddmStructureId, defaultLocale, fieldDisplayNamesSB, fields);
        }
    }

    private Field _createField(DDMFormField ddmFormField, List<DDMFormFieldValue> ddmFormFieldValues, DDMFormFieldValue ddmFormFieldValue, long ddmStructureId, Locale defaultLocale) throws PortalException {
        Field field = new Field();
        field.setDDMStructureId(ddmStructureId);
        field.setDefaultLocale(defaultLocale);
        field.setName(ddmFormFieldValue.getName());
        Set<Locale> availableLocales = this._getAvailableLocales(ddmFormFieldValues, ddmFormField.getName());
        Value value = ddmFormFieldValue.getValue();
        if (MapUtil.isEmpty((Map)value.getValues())) {
            LocalizedValue predefinedValue = ddmFormField.getPredefinedValue();
            Map predefinedValuesMap = predefinedValue.getValues();
            if (predefinedValuesMap.isEmpty()) {
                LocalizedValue localizedValue = new LocalizedValue(defaultLocale);
                localizedValue.addString(defaultLocale, "");
                ddmFormField.setPredefinedValue(localizedValue);
            }
            value = ddmFormField.getPredefinedValue();
            availableLocales.addAll(value.getAvailableLocales());
        }
        if (!value.isLocalized()) {
            field.addValue(defaultLocale, FieldConstants.getSerializable((Locale)defaultLocale, (Locale)LocaleUtil.ROOT, (String)ddmFormField.getDataType(), (String)value.getString(LocaleUtil.ROOT)));
            return field;
        }
        for (Locale availableLocale : availableLocales) {
            field.addValue(availableLocale, FieldConstants.getSerializable((Locale)availableLocale, (Locale)availableLocale, (String)ddmFormField.getDataType(), (String)value.getString(availableLocale)));
        }
        return field;
    }

    private Set<Locale> _getAvailableLocales(List<DDMFormFieldValue> ddmFormFieldValues, String name) {
        HashSet<Locale> availableLocales = new HashSet<Locale>();
        for (DDMFormFieldValue ddmFormFieldValue : DDMFormValues.getDDMFormFieldValues(ddmFormFieldValues, (String)name, (boolean)true)) {
            Value value = ddmFormFieldValue.getValue();
            if (value == null) continue;
            availableLocales.addAll(value.getAvailableLocales());
        }
        return availableLocales;
    }
}

