/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.dynamic.data.mapping.model.impl;

import com.liferay.dynamic.data.mapping.model.DDMStructureLayout;
import com.liferay.dynamic.data.mapping.service.DDMStructureLayoutLocalServiceUtil;

/**
 * The extended model base implementation for the DDMStructureLayout service. Represents a row in the &quot;DDMStructureLayout&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link DDMStructureLayoutImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see DDMStructureLayoutImpl
 * @see DDMStructureLayout
 * @generated
 */
public abstract class DDMStructureLayoutBaseImpl
	extends DDMStructureLayoutModelImpl implements DDMStructureLayout {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a ddm structure layout model instance should use the <code>DDMStructureLayout</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			DDMStructureLayoutLocalServiceUtil.addDDMStructureLayout(this);
		}
		else {
			DDMStructureLayoutLocalServiceUtil.updateDDMStructureLayout(this);
		}
	}

}