/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.io.exporter;

import com.liferay.dynamic.data.mapping.io.exporter.DDMFormInstanceRecordWriter;
import com.liferay.dynamic.data.mapping.io.exporter.DDMFormInstanceRecordWriterRequest;
import com.liferay.dynamic.data.mapping.io.exporter.DDMFormInstanceRecordWriterResponse;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;

@Component(property={"ddm.form.instance.record.writer.type=xml"}, service={DDMFormInstanceRecordWriter.class})
public class DDMFormInstanceRecordXMLWriter
implements DDMFormInstanceRecordWriter {
    public DDMFormInstanceRecordWriterResponse write(DDMFormInstanceRecordWriterRequest ddmFormInstanceRecordWriterRequest) throws Exception {
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("root");
        Map ddmFormFieldsLabel = ddmFormInstanceRecordWriterRequest.getDDMFormFieldsLabel();
        List ddmFormFieldsValueList = ddmFormInstanceRecordWriterRequest.getDDMFormFieldValues();
        for (Map ddmFormFieldsValue : ddmFormFieldsValueList) {
            this.addFieldElements(rootElement.addElement("fields"), ddmFormFieldsLabel, ddmFormFieldsValue);
        }
        String xml = document.asXML();
        DDMFormInstanceRecordWriterResponse.Builder builder = DDMFormInstanceRecordWriterResponse.Builder.newBuilder((byte[])xml.getBytes());
        return builder.build();
    }

    protected void addFieldElement(Element element, String label, String value) {
        Element fieldElement = element.addElement("field");
        Element labelElement = fieldElement.addElement("label");
        labelElement.addText(label);
        Element valueElement = fieldElement.addElement("value");
        valueElement.addText(value);
    }

    protected void addFieldElements(Element element, Map<String, String> ddmFormFieldsLabel, Map<String, String> ddmFormFieldsValue) {
        for (Map.Entry<String, String> entry : ddmFormFieldsValue.entrySet()) {
            this.addFieldElement(element, ddmFormFieldsLabel.get(entry.getKey()), entry.getValue());
        }
    }
}

