/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.dynamic.data.mapping.model.impl;

import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.service.DDMStructureVersionLocalServiceUtil;

/**
 * The extended model base implementation for the DDMStructureVersion service. Represents a row in the &quot;DDMStructureVersion&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link DDMStructureVersionImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see DDMStructureVersionImpl
 * @see DDMStructureVersion
 * @generated
 */
public abstract class DDMStructureVersionBaseImpl
	extends DDMStructureVersionModelImpl implements DDMStructureVersion {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a ddm structure version model instance should use the <code>DDMStructureVersion</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			DDMStructureVersionLocalServiceUtil.addDDMStructureVersion(this);
		}
		else {
			DDMStructureVersionLocalServiceUtil.updateDDMStructureVersion(this);
		}
	}

}