/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.service.impl;

import com.liferay.dynamic.data.mapping.internal.search.util.DDMSearchHelper;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.security.permission.DDMPermissionSupport;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.service.base.DDMStructureServiceBaseImpl;
import com.liferay.dynamic.data.mapping.service.persistence.DDMStructurePersistence;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=ddm", "json.web.service.context.path=DDMStructure"}, service={AopService.class})
public class DDMStructureServiceImpl
extends DDMStructureServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(DDMStructureServiceImpl.class);
    private static volatile ModelResourcePermission<DDMStructure> _ddmStructureModelResourcePermission = ModelResourcePermissionFactory.getInstance(DDMStructureServiceImpl.class, (String)"_ddmStructureModelResourcePermission", DDMStructure.class);
    @Reference
    private DDMPermissionSupport _ddmPermissionSupport;
    @Reference
    private DDMSearchHelper _ddmSearchHelper;

    public DDMStructure addStructure(long groupId, long parentStructureId, long classNameId, String structureKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, DDMForm ddmForm, DDMFormLayout ddmFormLayout, String storageType, int type, ServiceContext serviceContext) throws PortalException {
        this._ddmPermissionSupport.checkAddStructurePermission(this.getPermissionChecker(), groupId, classNameId);
        return this.ddmStructureLocalService.addStructure(this.getUserId(), groupId, parentStructureId, classNameId, structureKey, nameMap, descriptionMap, ddmForm, ddmFormLayout, storageType, type, serviceContext);
    }

    public DDMStructure addStructure(long groupId, long classNameId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, DDMForm ddmForm, DDMFormLayout ddmFormLayout, String storageType, ServiceContext serviceContext) throws PortalException {
        this._ddmPermissionSupport.checkAddStructurePermission(this.getPermissionChecker(), groupId, classNameId);
        return this.ddmStructureLocalService.addStructure(this.getUserId(), groupId, classNameId, nameMap, descriptionMap, ddmForm, ddmFormLayout, storageType, serviceContext);
    }

    public DDMStructure addStructure(long groupId, String parentStructureKey, long classNameId, String structureKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, DDMForm ddmForm, DDMFormLayout ddmFormLayout, String storageType, int type, ServiceContext serviceContext) throws PortalException {
        this._ddmPermissionSupport.checkAddStructurePermission(this.getPermissionChecker(), groupId, classNameId);
        return this.ddmStructureLocalService.addStructure(this.getUserId(), groupId, parentStructureKey, classNameId, structureKey, nameMap, descriptionMap, ddmForm, ddmFormLayout, storageType, type, serviceContext);
    }

    public DDMStructure copyStructure(long structureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, ServiceContext serviceContext) throws PortalException {
        DDMStructure structure = this.ddmStructurePersistence.findByPrimaryKey(structureId);
        _ddmStructureModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)structure, "VIEW");
        this._ddmPermissionSupport.checkAddStructurePermission(this.getPermissionChecker(), serviceContext.getScopeGroupId(), structure.getClassNameId());
        return this.ddmStructureLocalService.copyStructure(this.getUserId(), structureId, nameMap, descriptionMap, serviceContext);
    }

    public DDMStructure copyStructure(long structureId, ServiceContext serviceContext) throws PortalException {
        DDMStructure structure = this.ddmStructurePersistence.findByPrimaryKey(structureId);
        _ddmStructureModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)structure, "VIEW");
        this._ddmPermissionSupport.checkAddStructurePermission(this.getPermissionChecker(), serviceContext.getScopeGroupId(), structure.getClassNameId());
        return this.ddmStructureLocalService.copyStructure(this.getUserId(), structureId, serviceContext);
    }

    public void deleteStructure(long structureId) throws PortalException {
        _ddmStructureModelResourcePermission.check(this.getPermissionChecker(), structureId, "DELETE");
        this.ddmStructureLocalService.deleteStructure(structureId);
    }

    public DDMStructure fetchStructure(long groupId, long classNameId, String structureKey) throws PortalException {
        DDMStructure ddmStructure = this.ddmStructurePersistence.fetchByG_C_S(groupId, classNameId, structureKey);
        if (ddmStructure != null) {
            _ddmStructureModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)ddmStructure, "VIEW");
        }
        return ddmStructure;
    }

    public DDMStructure fetchStructure(long groupId, long classNameId, String structureKey, boolean includeAncestorStructures) throws PortalException {
        DDMStructure ddmStructure = this.ddmStructureLocalService.fetchStructure(groupId, classNameId, structureKey, includeAncestorStructures);
        if (ddmStructure != null) {
            _ddmStructureModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)ddmStructure, "VIEW");
        }
        return ddmStructure;
    }

    public DDMStructure getStructure(long structureId) throws PortalException {
        _ddmStructureModelResourcePermission.check(this.getPermissionChecker(), structureId, "VIEW");
        return this.ddmStructurePersistence.findByPrimaryKey(structureId);
    }

    public DDMStructure getStructure(long groupId, long classNameId, String structureKey) throws PortalException {
        DDMStructure structure = this.ddmStructureLocalService.getStructure(groupId, classNameId, structureKey);
        _ddmStructureModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)structure, "VIEW");
        return structure;
    }

    public DDMStructure getStructure(long groupId, long classNameId, String structureKey, boolean includeAncestorStructures) throws PortalException {
        DDMStructure structure = this.ddmStructureLocalService.getStructure(groupId, classNameId, structureKey, includeAncestorStructures);
        _ddmStructureModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)structure, "VIEW");
        return structure;
    }

    public List<DDMStructure> getStructures(long companyId, long[] groupIds, long classNameId, int status) {
        try {
            SearchContext searchContext = this._ddmSearchHelper.buildStructureSearchContext(companyId, groupIds, this.getUserId(), classNameId, null, "", "", "", null, status, -1, -1, null);
            return this._ddmSearchHelper.doSearch(searchContext, DDMStructure.class, arg_0 -> ((DDMStructurePersistence)this.ddmStructurePersistence).findByPrimaryKey(arg_0));
        }
        catch (PrincipalException principalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)principalException, (Throwable)principalException);
            }
            return Collections.emptyList();
        }
    }

    public List<DDMStructure> getStructures(long companyId, long[] groupIds, long classNameId, int status, int start, int end, OrderByComparator<DDMStructure> orderByComparator) {
        try {
            SearchContext searchContext = this._ddmSearchHelper.buildStructureSearchContext(companyId, groupIds, this.getUserId(), classNameId, null, "", "", "", null, status, start, end, orderByComparator);
            return this._ddmSearchHelper.doSearch(searchContext, DDMStructure.class, arg_0 -> ((DDMStructurePersistence)this.ddmStructurePersistence).findByPrimaryKey(arg_0));
        }
        catch (PrincipalException principalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)principalException, (Throwable)principalException);
            }
            return Collections.emptyList();
        }
    }

    public List<DDMStructure> getStructures(long companyId, long[] groupIds, long classNameId, int start, int end, OrderByComparator<DDMStructure> orderByComparator) {
        return this.ddmStructureFinder.filterFindByC_G_C_S(companyId, groupIds, classNameId, -1, start, end, orderByComparator);
    }

    public List<DDMStructure> getStructures(long companyId, long[] groupIds, long classNameId, String keywords, int status, int start, int end, OrderByComparator<DDMStructure> orderByComparator) {
        return this.ddmStructureLocalService.getStructures(companyId, groupIds, classNameId, keywords, status, start, end, orderByComparator);
    }

    public int getStructuresCount(long companyId, long[] groupIds, long classNameId) {
        return this.ddmStructureFinder.filterCountByC_G_C_S(companyId, groupIds, classNameId, -1);
    }

    public int getStructuresCount(long companyId, long[] groupIds, long classNameId, String keywords, int status) {
        return this.ddmStructureLocalService.getStructuresCount(companyId, groupIds, classNameId, keywords, status);
    }

    public void revertStructure(long structureId, String version, ServiceContext serviceContext) throws PortalException {
        _ddmStructureModelResourcePermission.check(this.getPermissionChecker(), structureId, "UPDATE");
        this.ddmStructureLocalService.revertStructure(this.getUserId(), structureId, version, serviceContext);
    }

    public List<DDMStructure> search(long companyId, long[] groupIds, long classNameId, String keywords, int type, int status, int start, int end, OrderByComparator<DDMStructure> orderByComparator) {
        try {
            SearchContext searchContext = this._ddmSearchHelper.buildStructureSearchContext(companyId, groupIds, this.getUserId(), classNameId, null, keywords, keywords, "", type, status, start, end, orderByComparator);
            return this._ddmSearchHelper.doSearch(searchContext, DDMStructure.class, arg_0 -> ((DDMStructurePersistence)this.ddmStructurePersistence).findByPrimaryKey(arg_0));
        }
        catch (PrincipalException principalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)principalException, (Throwable)principalException);
            }
            return Collections.emptyList();
        }
    }

    public List<DDMStructure> search(long companyId, long[] groupIds, long classNameId, String keywords, int status, int start, int end, OrderByComparator<DDMStructure> orderByComparator) {
        try {
            SearchContext searchContext = this._ddmSearchHelper.buildStructureSearchContext(companyId, groupIds, this.getUserId(), classNameId, null, keywords, keywords, "", null, status, start, end, orderByComparator);
            return this._ddmSearchHelper.doSearch(searchContext, DDMStructure.class, arg_0 -> ((DDMStructureLocalService)this.ddmStructureLocalService).fetchStructure(arg_0));
        }
        catch (PrincipalException principalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)principalException, (Throwable)principalException);
            }
            return Collections.emptyList();
        }
    }

    public List<DDMStructure> search(long companyId, long[] groupIds, long classNameId, String name, String description, String storageType, int type, int status, boolean andOperator, int start, int end, OrderByComparator<DDMStructure> orderByComparator) {
        try {
            SearchContext searchContext = this._ddmSearchHelper.buildStructureSearchContext(companyId, groupIds, this.getUserId(), classNameId, null, name, description, storageType, type, status, start, end, orderByComparator);
            return this._ddmSearchHelper.doSearch(searchContext, DDMStructure.class, arg_0 -> ((DDMStructurePersistence)this.ddmStructurePersistence).findByPrimaryKey(arg_0));
        }
        catch (PrincipalException principalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)principalException, (Throwable)principalException);
            }
            return Collections.emptyList();
        }
    }

    public int searchCount(long companyId, long[] groupIds, long classNameId, String keywords, int status) {
        try {
            SearchContext searchContext = this._ddmSearchHelper.buildStructureSearchContext(companyId, groupIds, this.getUserId(), classNameId, null, keywords, keywords, "", null, status, -1, -1, null);
            return this._ddmSearchHelper.doSearchCount(searchContext, DDMStructure.class);
        }
        catch (PrincipalException principalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)principalException, (Throwable)principalException);
            }
            return 0;
        }
    }

    public int searchCount(long companyId, long[] groupIds, long classNameId, String keywords, int type, int status) {
        try {
            SearchContext searchContext = this._ddmSearchHelper.buildStructureSearchContext(companyId, groupIds, this.getUserId(), classNameId, null, keywords, keywords, "", type, status, -1, -1, null);
            return this._ddmSearchHelper.doSearchCount(searchContext, DDMStructure.class);
        }
        catch (PrincipalException principalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)principalException, (Throwable)principalException);
            }
            return 0;
        }
    }

    public int searchCount(long companyId, long[] groupIds, long classNameId, String name, String description, String storageType, int type, int status, boolean andOperator) {
        try {
            SearchContext searchContext = this._ddmSearchHelper.buildStructureSearchContext(companyId, groupIds, this.getUserId(), classNameId, null, name, description, storageType, type, status, -1, -1, null);
            return this._ddmSearchHelper.doSearchCount(searchContext, DDMStructure.class);
        }
        catch (PrincipalException principalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)principalException, (Throwable)principalException);
            }
            return 0;
        }
    }

    public DDMStructure updateStructure(long groupId, long parentStructureId, long classNameId, String structureKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, DDMForm ddmForm, DDMFormLayout ddmFormLayout, ServiceContext serviceContext) throws PortalException {
        DDMStructure structure = this.ddmStructurePersistence.findByG_C_S(groupId, classNameId, structureKey);
        _ddmStructureModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)structure, "UPDATE");
        return this.ddmStructureLocalService.updateStructure(this.getUserId(), groupId, parentStructureId, classNameId, structureKey, nameMap, descriptionMap, ddmForm, ddmFormLayout, serviceContext);
    }

    public DDMStructure updateStructure(long structureId, long parentStructureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, DDMForm ddmForm, DDMFormLayout ddmFormLayout, ServiceContext serviceContext) throws PortalException {
        _ddmStructureModelResourcePermission.check(this.getPermissionChecker(), structureId, "UPDATE");
        return this.ddmStructureLocalService.updateStructure(this.getUserId(), structureId, parentStructureId, nameMap, descriptionMap, ddmForm, ddmFormLayout, serviceContext);
    }
}

