/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.values.factory.internal;

import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldValueRequestParameterRetriever;
import com.liferay.dynamic.data.mapping.form.field.type.DefaultDDMFormFieldValueRequestParameterRetriever;
import com.liferay.dynamic.data.mapping.form.values.factory.DDMFormValuesFactory;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMFormFieldParameterNameUtil;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesFactoryUtil;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import jakarta.portlet.PortletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={DDMFormValuesFactory.class})
public class DDMFormValuesFactoryImpl
implements DDMFormValuesFactory {
    private final DDMFormFieldValueRequestParameterRetriever _defaultDDMFormFieldValueRequestParameterRetriever = new DefaultDDMFormFieldValueRequestParameterRetriever();
    @Reference
    private Language _language;
    @Reference
    private Portal _portal;
    private ServiceTrackerMap<String, DDMFormFieldValueRequestParameterRetriever> _serviceTrackerMap;

    public DDMFormValues create(HttpServletRequest httpServletRequest, DDMForm ddmForm) {
        DDMFormValues ddmFormValues = new DDMFormValues(ddmForm);
        this._setDDMFormValuesAvailableLocales(httpServletRequest, ddmForm, ddmFormValues);
        this._setDDMFormValuesDefaultLocale(httpServletRequest, ddmForm, ddmFormValues);
        this._setDDMFormFieldValues(httpServletRequest, ddmFormValues);
        return ddmFormValues;
    }

    public DDMFormValues create(PortletRequest portletRequest, DDMForm ddmForm) {
        return this.create(this._portal.getHttpServletRequest(portletRequest), ddmForm);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, DDMFormFieldValueRequestParameterRetriever.class, (String)"ddm.form.field.type.name");
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    private void _checkDDMFormFieldParameterNames(DDMForm ddmForm, Set<String> ddmFormFieldParameterNames) {
        if (ddmFormFieldParameterNames.isEmpty()) {
            ddmFormFieldParameterNames.addAll(this._createDefaultDDMFormFieldParameterNames(ddmForm));
            return;
        }
        HashSet<String> checkedDDMFormFieldNames = new HashSet<String>();
        this._checkDDMFormFieldParameterNames(checkedDDMFormFieldNames, ddmForm.getDDMFormFields(), "", ddmFormFieldParameterNames);
    }

    private void _checkDDMFormFieldParameterNames(Set<String> checkedDDMFormFieldNames, List<DDMFormField> ddmFormFields, String parentDDMFormFieldParameterName, Set<String> ddmFormFieldParameterNames) {
        for (DDMFormField ddmFormField : ddmFormFields) {
            if (checkedDDMFormFieldNames.contains(ddmFormField.getName())) continue;
            Set<String> filteredDDMFormFieldParameterNames = this._filterDDMFormFieldParameterNames(ddmFormField, ddmFormFieldParameterNames);
            boolean containsDefaultDDMFormFieldParameterName = this._containsDefaultDDMFormFieldParameterName(filteredDDMFormFieldParameterNames, this._getDDMFormFieldParameterPrefix(ddmFormField, parentDDMFormFieldParameterName));
            if (!containsDefaultDDMFormFieldParameterName) {
                String defaultDDMFormFieldParameterName = this._createDefaultDDMFormFieldParameterName(ddmFormField, parentDDMFormFieldParameterName);
                ddmFormFieldParameterNames.add(defaultDDMFormFieldParameterName);
                this._checkDDMFormFieldParameterNames(checkedDDMFormFieldNames, ddmFormField.getNestedDDMFormFields(), "", ddmFormFieldParameterNames);
            }
            for (String filteredDDMFormFieldParameterName : filteredDDMFormFieldParameterNames) {
                this._checkDDMFormFieldParameterNames(checkedDDMFormFieldNames, ddmFormField.getNestedDDMFormFields(), filteredDDMFormFieldParameterName, ddmFormFieldParameterNames);
            }
            checkedDDMFormFieldNames.add(ddmFormField.getName());
        }
    }

    private boolean _containsDefaultDDMFormFieldParameterName(Set<String> filteredDDMFormFieldParameterNames, String ddmFormFieldParameterPrefix) {
        for (String filteredDDMFormFieldParameterName : filteredDDMFormFieldParameterNames) {
            if (!filteredDDMFormFieldParameterName.startsWith(ddmFormFieldParameterPrefix)) continue;
            return true;
        }
        return false;
    }

    private DDMFormFieldValue _createDDMFormFieldValue(HttpServletRequest httpServletRequest, DDMFormValues ddmFormValues, String ddmFormFieldParameterName, Map<String, DDMFormField> ddmFormFieldsMap) {
        String[] lastDDMFormFieldParameterNameParts = DDMFormFieldParameterNameUtil.getLastDDMFormFieldParameterNameParts((String)ddmFormFieldParameterName);
        DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue(lastDDMFormFieldParameterNameParts[1]);
        String fieldName = lastDDMFormFieldParameterNameParts[0];
        ddmFormFieldValue.setName(fieldName);
        DDMFormField ddmFormField = ddmFormFieldsMap.get(fieldName);
        if (ddmFormField == null) {
            return ddmFormFieldValue;
        }
        ddmFormFieldValue.setFieldReference(ddmFormField.getFieldReference());
        if (ddmFormField.isTransient()) {
            return ddmFormFieldValue;
        }
        if (ddmFormField.isLocalizable()) {
            this._setDDMFormFieldValueLocalizedValue(httpServletRequest, ddmFormField.getType(), ddmFormFieldParameterName, ddmFormField.getPredefinedValue(), ddmFormFieldValue, ddmFormValues.getAvailableLocales(), ddmFormValues.getDefaultLocale());
        } else {
            this._setDDMFormFieldValueUnlocalizedValue(httpServletRequest, ddmFormField.getType(), ddmFormFieldParameterName, ddmFormField.getPredefinedValue(), ddmFormFieldValue, ddmFormValues.getDefaultLocale());
        }
        return ddmFormFieldValue;
    }

    private Map<String, DDMFormFieldValue> _createDDMFormFieldValuesMap(HttpServletRequest httpServletRequest, DDMForm ddmForm, DDMFormValues ddmFormValues) {
        HashMap<String, DDMFormFieldValue> ddmFormFieldValuesMap = new HashMap<String, DDMFormFieldValue>();
        Set<String> ddmFormFieldParameterNames = this._getDDMFormFieldParameterNames(httpServletRequest, ddmForm);
        Map ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
        for (String ddmFormFieldParameterName : ddmFormFieldParameterNames) {
            DDMFormFieldValue ddmFormFieldValue = this._createDDMFormFieldValue(httpServletRequest, ddmFormValues, ddmFormFieldParameterName, ddmFormFieldsMap);
            ddmFormFieldValuesMap.put(ddmFormFieldParameterName, ddmFormFieldValue);
        }
        return ddmFormFieldValuesMap;
    }

    private String _createDefaultDDMFormFieldParameterName(DDMFormField ddmFormField, String parentDefaultDDMFormFieldParameterName) {
        StringBundler sb = new StringBundler(7);
        if (Validator.isNotNull((String)parentDefaultDDMFormFieldParameterName)) {
            sb.append(parentDefaultDDMFormFieldParameterName);
            sb.append("#");
        }
        sb.append(ddmFormField.getName());
        sb.append("$");
        sb.append(StringUtil.randomString());
        sb.append("$");
        sb.append(0);
        return sb.toString();
    }

    private Set<String> _createDefaultDDMFormFieldParameterNames(DDMForm ddmForm) {
        TreeSet<String> defaultDDMFormFieldParameterNames = new TreeSet<String>();
        this._poupulateDefaultDDMFormFieldParameterNames(ddmForm.getDDMFormFields(), "", defaultDDMFormFieldParameterNames);
        return defaultDDMFormFieldParameterNames;
    }

    private String _extractPrefix(String ddmFormFieldParameterName) {
        return StringUtil.extractLast((String)ddmFormFieldParameterName, (String)"ddm$$");
    }

    private String _extractSuffix(String ddmFormFieldParameterName) {
        int pos = ddmFormFieldParameterName.lastIndexOf("$$");
        return ddmFormFieldParameterName.substring(0, pos);
    }

    private Set<String> _filterDDMFormFieldParameterNames(DDMFormField ddmFormField, Set<String> ddmFormFieldParameterNames) {
        HashSet<String> filteredDDMFormFieldParameterNames = new HashSet<String>();
        for (String ddmFormFieldParameterName : ddmFormFieldParameterNames) {
            String[] ddmFormFieldParameterNameParts = DDMFormFieldParameterNameUtil.getLastDDMFormFieldParameterNameParts((String)ddmFormFieldParameterName);
            String fieldName = ddmFormFieldParameterNameParts[0];
            if (!fieldName.equals(ddmFormField.getName())) continue;
            filteredDDMFormFieldParameterNames.add(ddmFormFieldParameterName);
        }
        return filteredDDMFormFieldParameterNames;
    }

    private Set<String> _getDDMFormFieldParameterNames(HttpServletRequest httpServletRequest, DDMForm ddmForm) {
        TreeSet<String> ddmFormFieldParameterNames = new TreeSet<String>();
        Map parameterMap = httpServletRequest.getParameterMap();
        for (String parameterName : parameterMap.keySet()) {
            if (!this._isDDMFormFieldParameter(parameterName)) continue;
            ddmFormFieldParameterNames.addAll(this._getDDMFormFieldParameterNames(parameterName));
        }
        this._checkDDMFormFieldParameterNames(ddmForm, ddmFormFieldParameterNames);
        return ddmFormFieldParameterNames;
    }

    private Set<String> _getDDMFormFieldParameterNames(String ddmFormFieldParameterName) {
        TreeSet<String> ddmFormFieldParameterNames = new TreeSet<String>();
        ddmFormFieldParameterName = this._extractPrefix(ddmFormFieldParameterName);
        ddmFormFieldParameterName = this._extractSuffix(ddmFormFieldParameterName);
        ddmFormFieldParameterNames.add(ddmFormFieldParameterName);
        int pos = ddmFormFieldParameterName.indexOf("#");
        while (pos != -1) {
            ddmFormFieldParameterNames.add(ddmFormFieldParameterName.substring(0, pos));
            pos = ddmFormFieldParameterName.indexOf("#", pos + 1);
        }
        return ddmFormFieldParameterNames;
    }

    private String _getDDMFormFieldParameterPrefix(DDMFormField ddmFormField, String parentDDMFormFieldParameterName) {
        if (Validator.isNull((String)parentDDMFormFieldParameterName)) {
            return ddmFormField.getName();
        }
        return StringBundler.concat((String[])new String[]{parentDDMFormFieldParameterName, "#", ddmFormField.getName()});
    }

    private String _getDDMFormFieldParameterValue(String defaultDDMFormFieldParameterValue, String fieldType, String fullDDMFormFieldParameterName, HttpServletRequest httpServletRequest) {
        DDMFormFieldValueRequestParameterRetriever ddmFormFieldValueRequestParameterRetriever = this._getDDMFormFieldValueRequestParameterRetriever(fieldType);
        return ddmFormFieldValueRequestParameterRetriever.get(httpServletRequest, fullDDMFormFieldParameterName, GetterUtil.getString((String)defaultDDMFormFieldParameterValue));
    }

    private DDMFormFieldValueRequestParameterRetriever _getDDMFormFieldValueRequestParameterRetriever(String fieldType) {
        if (!this._serviceTrackerMap.containsKey((Object)fieldType)) {
            return this._defaultDDMFormFieldValueRequestParameterRetriever;
        }
        return (DDMFormFieldValueRequestParameterRetriever)this._serviceTrackerMap.getService((Object)fieldType);
    }

    private List<DDMFormFieldValue> _getDDMFormFieldValues(HttpServletRequest httpServletRequest, DDMForm ddmForm, DDMFormValues ddmFormValues) {
        Map<String, DDMFormFieldValue> ddmFormFieldValuesMap = this._createDDMFormFieldValuesMap(httpServletRequest, ddmForm, ddmFormValues);
        return DDMFormValuesFactoryUtil.getDDMFormFieldValues(ddmFormFieldValuesMap, (List)ddmForm.getDDMFormFields());
    }

    private Locale _getDefaultLocale(HttpServletRequest httpServletRequest, Locale defaultLocale, Set<Locale> availableLocales) {
        String defaultLanguageId = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"defaultLanguageId");
        if (Validator.isNotNull((String)defaultLanguageId)) {
            return LocaleUtil.fromLanguageId((String)defaultLanguageId);
        }
        Locale httpServletRequestLocale = LocaleUtil.fromLanguageId((String)this._language.getLanguageId(httpServletRequest));
        if (availableLocales.contains(httpServletRequestLocale)) {
            return httpServletRequestLocale;
        }
        return defaultLocale;
    }

    private String _getFullDDMFormFieldParameterName(String ddmFormFieldParameterName, Locale locale) {
        return StringBundler.concat((String[])new String[]{"ddm$$", ddmFormFieldParameterName, "$$", LocaleUtil.toLanguageId((Locale)locale)});
    }

    private boolean _isDDMFormFieldParameter(String parameterName) {
        return parameterName.startsWith("ddm$$");
    }

    private void _poupulateDefaultDDMFormFieldParameterNames(List<DDMFormField> ddmFormFields, String parentDefaultDDMFormFieldParameterName, Set<String> defaultDDMFormFieldParameterNames) {
        for (DDMFormField ddmFormField : ddmFormFields) {
            String defaultDDMFormFieldParameterName = this._createDefaultDDMFormFieldParameterName(ddmFormField, parentDefaultDDMFormFieldParameterName);
            defaultDDMFormFieldParameterNames.add(defaultDDMFormFieldParameterName);
            this._poupulateDefaultDDMFormFieldParameterNames(ddmFormField.getNestedDDMFormFields(), defaultDDMFormFieldParameterName, defaultDDMFormFieldParameterNames);
        }
    }

    private void _setDDMFormFieldValueLocalizedValue(HttpServletRequest httpServletRequest, String fieldType, String ddmFormFieldParameterName, LocalizedValue predefinedValue, DDMFormFieldValue ddmFormFieldValue, Set<Locale> availableLocales, Locale defaultLocale) {
        LocalizedValue value = new LocalizedValue(defaultLocale);
        boolean persistDefaultValues = ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)"persistDefaultValues", (boolean)true);
        for (Locale availableLocale : availableLocales) {
            String fullDDMFormFieldParameterName = this._getFullDDMFormFieldParameterName(ddmFormFieldParameterName, availableLocale);
            String parameterValue = httpServletRequest.getParameter(fullDDMFormFieldParameterName);
            if (!persistDefaultValues && (!GetterUtil.getBoolean((String)httpServletRequest.getParameter(fullDDMFormFieldParameterName + "_edited"), (boolean)true) || parameterValue == null)) continue;
            String ddmFormFieldParameterValue = this._getDDMFormFieldParameterValue(predefinedValue.getString(availableLocale), fieldType, fullDDMFormFieldParameterName, httpServletRequest);
            value.addString(availableLocale, ddmFormFieldParameterValue);
        }
        ddmFormFieldValue.setValue((Value)value);
    }

    private void _setDDMFormFieldValues(HttpServletRequest httpServletRequest, DDMFormValues ddmFormValues) {
        List<DDMFormFieldValue> ddmFormFieldValues = this._getDDMFormFieldValues(httpServletRequest, ddmFormValues.getDDMForm(), ddmFormValues);
        ddmFormValues.setDDMFormFieldValues(ddmFormFieldValues);
    }

    private void _setDDMFormFieldValueUnlocalizedValue(HttpServletRequest httpServletRequest, String fieldType, String ddmFormFieldParameterName, LocalizedValue predefinedValue, DDMFormFieldValue ddmFormFieldValue, Locale defaultLocale) {
        String ddmFormFieldParameterValue = this._getDDMFormFieldParameterValue(predefinedValue.getString(defaultLocale), fieldType, this._getFullDDMFormFieldParameterName(ddmFormFieldParameterName, defaultLocale), httpServletRequest);
        UnlocalizedValue value = new UnlocalizedValue(ddmFormFieldParameterValue);
        ddmFormFieldValue.setValue((Value)value);
    }

    private void _setDDMFormValuesAvailableLocales(HttpServletRequest httpServletRequest, DDMForm ddmForm, DDMFormValues ddmFormValues) {
        Object[] availableLocaleStrings = ParamUtil.getStringValues((HttpServletRequest)httpServletRequest, (String)"availableLocales");
        if (ArrayUtil.isEmpty((Object[])availableLocaleStrings)) {
            for (Locale availableLocale : ddmForm.getAvailableLocales()) {
                ddmFormValues.addAvailableLocale(availableLocale);
            }
        } else {
            long groupId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"groupId");
            Set siteAvailableLocales = this._language.getAvailableLocales(groupId);
            String[] siteAvailableLocaleStrings = LocaleUtil.toLanguageIds((Collection)siteAvailableLocales);
            for (Object availableLocaleString : availableLocaleStrings) {
                if (!ArrayUtil.contains((String[])siteAvailableLocaleStrings, (String)availableLocaleString, (boolean)false)) continue;
                ddmFormValues.addAvailableLocale(LocaleUtil.fromLanguageId((String)availableLocaleString));
            }
        }
    }

    private void _setDDMFormValuesDefaultLocale(HttpServletRequest httpServletRequest, DDMForm ddmForm, DDMFormValues ddmFormValues) {
        ddmFormValues.setDefaultLocale(this._getDefaultLocale(httpServletRequest, ddmForm.getDefaultLocale(), ddmForm.getAvailableLocales()));
    }
}

