/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.renderer.internal;

import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class DefaultDDMFormValuesFactory {
    private final DDMForm _ddmForm;

    public DefaultDDMFormValuesFactory(DDMForm ddmForm) {
        this._ddmForm = ddmForm;
    }

    public DDMFormValues create() {
        DDMFormValues ddmFormValues = new DDMFormValues(this._ddmForm);
        ddmFormValues.setAvailableLocales(this._ddmForm.getAvailableLocales());
        ddmFormValues.setDefaultLocale(this._ddmForm.getDefaultLocale());
        this.populate(ddmFormValues);
        return ddmFormValues;
    }

    public void populate(DDMFormValues ddmFormValues) {
        this._populate(arg_0 -> ((DDMFormValues)ddmFormValues).addDDMFormFieldValue(arg_0), this._ddmForm.getDDMFormFields(), ddmFormValues.getDDMFormFieldValuesMap(false));
    }

    private DDMFormFieldValue _createDefaultDDMFormFieldValue(DDMFormField ddmFormField) {
        DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue();
        ddmFormFieldValue.setFieldReference(ddmFormField.getFieldReference());
        ddmFormFieldValue.setName(ddmFormField.getName());
        ddmFormFieldValue.setValue(this._createDefaultValue(ddmFormField));
        for (DDMFormField nestedDDMFormField : ddmFormField.getNestedDDMFormFields()) {
            ddmFormFieldValue.addNestedDDMFormFieldValue(this._createDefaultDDMFormFieldValue(nestedDDMFormField));
        }
        return ddmFormFieldValue;
    }

    private LocalizedValue _createDefaultLocalizedValue(String defaultValueString) {
        LocalizedValue value = new LocalizedValue(this._ddmForm.getDefaultLocale());
        value.addString(this._ddmForm.getDefaultLocale(), defaultValueString);
        return value;
    }

    private Value _createDefaultValue(DDMFormField ddmFormField) {
        LocalizedValue defaultValue = ddmFormField.getPredefinedValue();
        if ((defaultValue == null || MapUtil.isEmpty((Map)defaultValue.getValues())) && (defaultValue = (LocalizedValue)ddmFormField.getProperty("initialValue")) == null) {
            defaultValue = this._createDefaultLocalizedValue("");
        }
        if (ddmFormField.isLocalizable()) {
            return defaultValue;
        }
        return new UnlocalizedValue(GetterUtil.getString((String)defaultValue.getString(this._ddmForm.getDefaultLocale())));
    }

    private void _populate(Consumer<DDMFormFieldValue> consumer, List<DDMFormField> ddmFormFields, Map<String, List<DDMFormFieldValue>> ddmFormFieldValuesMap) {
        if (ddmFormFields == null) {
            return;
        }
        ddmFormFields.forEach(ddmFormField -> {
            List ddmFormFieldValues = (List)ddmFormFieldValuesMap.get(ddmFormField.getName());
            if (ddmFormFieldValues != null) {
                ddmFormFieldValues.forEach(ddmFormFieldValue -> this._populate(arg_0 -> ((DDMFormFieldValue)ddmFormFieldValue).addNestedDDMFormFieldValue(arg_0), ddmFormField.getNestedDDMFormFields(), ddmFormFieldValue.getNestedDDMFormFieldValuesMap()));
            } else {
                consumer.accept(this._createDefaultDDMFormFieldValue((DDMFormField)ddmFormField));
            }
        });
    }
}

