Liferay.Loader.define("dynamic-data-mapping-form-renderer@4.0.75/js/store/actions/handlePaginationNextClicked.es", ['module', 'exports', 'require', '../../util/evaluation.es', '../../util/visitors.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _evaluation = require("../../util/evaluation.es");

  var _visitors = require("../../util/visitors.es");

  /**
   * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
   * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
   */
  var _default = function _default(evaluatorContext, dispatch) {
    var activePage = evaluatorContext.activePage,
        formId = evaluatorContext.formId,
        pages = evaluatorContext.pages;
    return (0, _evaluation.evaluate)(null, evaluatorContext).then(function (evaluatedPages) {
      var validPage = true;
      var visitor = new _visitors.PagesVisitor(evaluatedPages);
      visitor.mapFields(function (_ref, fieldIndex, columnIndex, rowIndex, pageIndex) {
        var valid = _ref.valid;

        if (activePage === pageIndex && !valid) {
          validPage = false;
        }
      });

      if (validPage) {
        var nextActivePageIndex = evaluatedPages.findIndex(function (_ref2, index) {
          var enabled = _ref2.enabled;
          var found = false;

          if (enabled && index > activePage) {
            found = true;
          }

          return found;
        });
        var activePageUpdated = Math.min(nextActivePageIndex, pages.length - 1);
        dispatch('activePageUpdated', activePageUpdated);
        Liferay.fire('ddmFormPageShow', {
          formId: formId,
          page: activePageUpdated,
          title: pages[activePageUpdated].title
        });
      } else {
        dispatch('pageValidationFailed', activePage);
      }
    });
  };

  exports["default"] = _default;
  //# sourceMappingURL=handlePaginationNextClicked.es.js.map
});
//# sourceMappingURL=handlePaginationNextClicked.es.js.map