/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.builder.internal.converter.visitor;

import com.liferay.dynamic.data.mapping.expression.model.AndExpression;
import com.liferay.dynamic.data.mapping.expression.model.ArrayExpression;
import com.liferay.dynamic.data.mapping.expression.model.BinaryExpression;
import com.liferay.dynamic.data.mapping.expression.model.ComparisonExpression;
import com.liferay.dynamic.data.mapping.expression.model.Expression;
import com.liferay.dynamic.data.mapping.expression.model.ExpressionVisitor;
import com.liferay.dynamic.data.mapping.expression.model.FloatingPointLiteral;
import com.liferay.dynamic.data.mapping.expression.model.FunctionCallExpression;
import com.liferay.dynamic.data.mapping.expression.model.IntegerLiteral;
import com.liferay.dynamic.data.mapping.expression.model.NotExpression;
import com.liferay.dynamic.data.mapping.expression.model.OrExpression;
import com.liferay.dynamic.data.mapping.expression.model.StringLiteral;
import com.liferay.dynamic.data.mapping.expression.model.Term;
import com.liferay.dynamic.data.mapping.spi.converter.model.SPIDDMFormRuleCondition;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;

public class ConditionExpressionVisitor
extends ExpressionVisitor<Object> {
    private static final Map<String, String> _functionNameOperators = HashMapBuilder.put((Object)"belongsTo", (Object)"belongs-to").put((Object)"contains", (Object)"contains").put((Object)"equals", (Object)"equals-to").put((Object)"isEmpty", (Object)"is-empty").build();
    private static final Map<String, String> _operators = HashMapBuilder.put((Object)"<", (Object)"less-than").put((Object)"<=", (Object)"less-than-equals").put((Object)">", (Object)"greater-than").put((Object)">=", (Object)"greater-than-equals").build();
    private boolean _andOperator = true;
    private final Stack<SPIDDMFormRuleCondition> _spiDDMFormRuleConditions = new Stack();

    public String getLogicalOperator() {
        if (this._andOperator) {
            return "AND";
        }
        return "OR";
    }

    public List<SPIDDMFormRuleCondition> getSPIDDMFormRuleConditions() {
        return this._spiDDMFormRuleConditions;
    }

    public Object visit(AndExpression andExpression) {
        this._andOperator = true;
        return this._visitLogicalExpression((BinaryExpression)andExpression);
    }

    public Object visit(ArrayExpression arrayExpression) {
        String value = arrayExpression.getValue();
        return new SPIDDMFormRuleCondition.Operand("list", value.replaceAll("\\[|\\]|'", ""));
    }

    public Object visit(ComparisonExpression comparisonExpression) {
        SPIDDMFormRuleCondition.Operand leftOperand = (SPIDDMFormRuleCondition.Operand)this.doVisit(comparisonExpression.getLeftOperandExpression());
        SPIDDMFormRuleCondition.Operand rightOperand = (SPIDDMFormRuleCondition.Operand)this.doVisit(comparisonExpression.getRightOperandExpression());
        SPIDDMFormRuleCondition spiDDMFormRuleCondition = new SPIDDMFormRuleCondition(_operators.get(comparisonExpression.getOperator()), Arrays.asList(leftOperand, rightOperand));
        this._spiDDMFormRuleConditions.push(spiDDMFormRuleCondition);
        return this._spiDDMFormRuleConditions;
    }

    public Object visit(FloatingPointLiteral floatingPointLiteral) {
        return new SPIDDMFormRuleCondition.Operand("double", floatingPointLiteral.getValue());
    }

    public Object visit(FunctionCallExpression functionCallExpression) {
        String functionName = functionCallExpression.getFunctionName();
        List parameterExpressions = functionCallExpression.getParameterExpressions();
        if (Objects.equals(functionName, "getJSONValue")) {
            SPIDDMFormRuleCondition.Operand operand = (SPIDDMFormRuleCondition.Operand)this.doVisit((Expression)parameterExpressions.get(0));
            return new SPIDDMFormRuleCondition.Operand("json", operand.getValue());
        }
        if (Objects.equals(functionName, "getOptionLabel")) {
            SPIDDMFormRuleCondition.Operand operand = (SPIDDMFormRuleCondition.Operand)this.doVisit((Expression)parameterExpressions.get(1));
            String operandType = operand.getType();
            if (StringUtil.equals((String)operand.getType(), (String)"string")) {
                operandType = "option";
            }
            return new SPIDDMFormRuleCondition.Operand(operandType, operand.getValue());
        }
        if (Objects.equals(functionName, "getValue")) {
            SPIDDMFormRuleCondition.Operand operand = (SPIDDMFormRuleCondition.Operand)this.doVisit((Expression)parameterExpressions.get(0));
            return new SPIDDMFormRuleCondition.Operand("field", operand.getValue());
        }
        ArrayList<SPIDDMFormRuleCondition.Operand> operands = new ArrayList<SPIDDMFormRuleCondition.Operand>();
        for (Expression parameterExpression : parameterExpressions) {
            FunctionCallExpression parameterFunctionCallExpression;
            if (parameterExpression instanceof FunctionCallExpression && StringUtil.equals((String)(parameterFunctionCallExpression = (FunctionCallExpression)parameterExpression).getFunctionName(), (String)"getOptionLabel")) {
                operands.add((SPIDDMFormRuleCondition.Operand)this.doVisit(parameterExpression));
                continue;
            }
            if (functionCallExpression.hasNestedFunctions()) {
                operands.add(new SPIDDMFormRuleCondition.Operand("condition", parameterExpression.toString()));
                continue;
            }
            operands.add((SPIDDMFormRuleCondition.Operand)this.doVisit(parameterExpression));
        }
        this._spiDDMFormRuleConditions.push(this._createDDMFormRuleCondition(functionName, operands));
        return this._spiDDMFormRuleConditions;
    }

    public Object visit(IntegerLiteral integerLiteral) {
        return new SPIDDMFormRuleCondition.Operand("integer", integerLiteral.getValue());
    }

    public Object visit(NotExpression notExpression) {
        this.doVisit(notExpression.getOperandExpression());
        SPIDDMFormRuleCondition spiDDMFormRuleCondition = this._spiDDMFormRuleConditions.peek();
        String operator = spiDDMFormRuleCondition.getOperator();
        spiDDMFormRuleCondition.setOperator("not-" + operator);
        return this._spiDDMFormRuleConditions;
    }

    public Object visit(OrExpression orExpression) {
        this._andOperator = false;
        return this._visitLogicalExpression((BinaryExpression)orExpression);
    }

    public Object visit(StringLiteral stringLiteral) {
        return new SPIDDMFormRuleCondition.Operand("string", stringLiteral.getValue());
    }

    public Object visit(Term term) {
        return new SPIDDMFormRuleCondition.Operand("field", term.getValue());
    }

    protected <T> T doVisit(Expression expression) {
        return (T)expression.accept((ExpressionVisitor)this);
    }

    private SPIDDMFormRuleCondition _createDDMFormRuleCondition(String functionName, List<SPIDDMFormRuleCondition.Operand> operands) {
        String functionNameOperator = _functionNameOperators.getOrDefault(functionName, functionName);
        return new SPIDDMFormRuleCondition(functionNameOperator, operands);
    }

    private List<SPIDDMFormRuleCondition> _visitLogicalExpression(BinaryExpression binaryExpression) {
        Object object1 = this.doVisit(binaryExpression.getLeftOperandExpression());
        Object object2 = this.doVisit(binaryExpression.getRightOperandExpression());
        if (object1 instanceof SPIDDMFormRuleCondition) {
            this._spiDDMFormRuleConditions.push((SPIDDMFormRuleCondition)object1);
        }
        if (object2 instanceof SPIDDMFormRuleCondition) {
            this._spiDDMFormRuleConditions.push((SPIDDMFormRuleCondition)object2);
        }
        return this._spiDDMFormRuleConditions;
    }
}

