/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.data.provider.instance.internal;

import com.liferay.dynamic.data.mapping.data.provider.DDMDataProvider;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderRequest;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderResponse;
import com.liferay.dynamic.data.mapping.storage.DDMStorageAdapterRegistry;
import com.liferay.dynamic.data.mapping.storage.StorageType;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.util.KeyValuePair;
import java.util.ArrayList;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"ddm.data.provider.instance.id=ddm-storage-types"}, service={DDMDataProvider.class})
public class DDMStorageTypesDataProvider
implements DDMDataProvider {
    @Reference
    protected DDMStorageAdapterRegistry ddmStorageAdapterRegistry;
    @Reference
    private Language _language;

    public DDMDataProviderResponse getData(DDMDataProviderRequest ddmDataProviderRequest) {
        ArrayList<KeyValuePair> keyValuePairs = new ArrayList<KeyValuePair>();
        Set storageTypes = this.ddmStorageAdapterRegistry.getDDMStorageAdapterTypes();
        HttpServletRequest httpServletRequest = (HttpServletRequest)ddmDataProviderRequest.getParameter("httpServletRequest", HttpServletRequest.class);
        for (String storageType : storageTypes) {
            if (storageType.equals(StorageType.JSON.getValue())) continue;
            if (httpServletRequest == null) {
                keyValuePairs.add(new KeyValuePair(storageType, storageType));
                continue;
            }
            keyValuePairs.add(new KeyValuePair(storageType, this._language.get(httpServletRequest, storageType + "[stands-for]", this._language.get(httpServletRequest, storageType))));
        }
        DDMDataProviderResponse.Builder builder = DDMDataProviderResponse.Builder.newBuilder();
        builder.withOutput("Default-Output", keyValuePairs);
        return builder.build();
    }

    public Class<?> getSettings() {
        throw new UnsupportedOperationException();
    }
}

