/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.data.provider.instance;

import com.liferay.dynamic.data.mapping.data.provider.DDMDataProvider;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderException;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderRequest;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderResponse;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.workflow.WorkflowDefinition;
import com.liferay.portal.kernel.workflow.WorkflowDefinitionManager;
import com.liferay.portal.kernel.workflow.WorkflowException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, property={"ddm.data.provider.instance.id=workflow-definitions"}, service={DDMDataProvider.class})
public class WorkflowDefinitionsDataProvider
implements DDMDataProvider {
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(proxy.bean=false)")
    protected volatile WorkflowDefinitionManager workflowDefinitionManager;

    public DDMDataProviderResponse getData(DDMDataProviderRequest ddmDataProviderRequest) throws DDMDataProviderException {
        ArrayList<KeyValuePair> keyValuePairs = new ArrayList<KeyValuePair>();
        Locale locale = ddmDataProviderRequest.getLocale();
        keyValuePairs.add(new KeyValuePair("no-workflow", LanguageUtil.get((Locale)locale, (String)"no-workflow")));
        DDMDataProviderResponse.Builder builder = DDMDataProviderResponse.Builder.newBuilder();
        if (this.workflowDefinitionManager == null) {
            builder = builder.withOutput("Default-Output", keyValuePairs);
            return builder.build();
        }
        try {
            List workflowDefinitions = this.workflowDefinitionManager.getActiveWorkflowDefinitions(ddmDataProviderRequest.getCompanyId(), -1, -1, null);
            String languageId = LocaleUtil.toLanguageId((Locale)locale);
            for (WorkflowDefinition workflowDefinition : workflowDefinitions) {
                String value = workflowDefinition.getName();
                keyValuePairs.add(new KeyValuePair(value, workflowDefinition.getTitle(languageId)));
            }
            builder = builder.withOutput("Default-Output", keyValuePairs);
        }
        catch (WorkflowException workflowException) {
            throw new DDMDataProviderException((Throwable)workflowException);
        }
        return builder.build();
    }

    public Class<?> getSettings() {
        throw new UnsupportedOperationException();
    }
}

