/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.versioning;

import com.liferay.document.library.kernel.model.DLFileEntryMetadata;
import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.model.DLVersionNumberIncrease;
import com.liferay.document.library.kernel.service.DLFileEntryMetadataLocalService;
import com.liferay.document.library.util.DLFileEntryTypeUtil;
import com.liferay.document.library.versioning.VersioningPolicy;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.DDMStorageEngineManager;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={VersioningPolicy.class})
public class MetadataVersioningPolicy
implements VersioningPolicy {
    private static final Log _log = LogFactoryUtil.getLog(MetadataVersioningPolicy.class);
    @Reference
    private DDMStorageEngineManager _ddmStorageEngineManager;
    @Reference
    private DLFileEntryMetadataLocalService _dlFileEntryMetadataLocalService;

    public DLVersionNumberIncrease computeDLVersionNumberIncrease(DLFileVersion previousDLFileVersion, DLFileVersion nextDLFileVersion) {
        if (!Objects.equals(previousDLFileVersion.getTitle(), nextDLFileVersion.getTitle()) || !Objects.equals(previousDLFileVersion.getFileName(), nextDLFileVersion.getFileName()) || !Objects.equals(previousDLFileVersion.getDescription(), nextDLFileVersion.getDescription()) || previousDLFileVersion.getFileEntryTypeId() != nextDLFileVersion.getFileEntryTypeId() || this._isDLFileEntryTypeUpdated(previousDLFileVersion, nextDLFileVersion) || this._isExpandoUpdated(previousDLFileVersion, nextDLFileVersion)) {
            return DLVersionNumberIncrease.MINOR;
        }
        return null;
    }

    private boolean _isDLFileEntryTypeUpdated(DLFileVersion previousDLFileVersion, DLFileVersion nextDLFileVersion) {
        try {
            DLFileEntryType dlFileEntryType = previousDLFileVersion.getDLFileEntryType();
            for (DDMStructure ddmStructure : DLFileEntryTypeUtil.getDDMStructures((DLFileEntryType)dlFileEntryType)) {
                DDMFormValues nextDDMFormValues;
                DLFileEntryMetadata previousFileEntryMetadata = this._dlFileEntryMetadataLocalService.fetchFileEntryMetadata(ddmStructure.getStructureId(), previousDLFileVersion.getFileVersionId());
                if (previousFileEntryMetadata == null) {
                    return true;
                }
                DLFileEntryMetadata nextFileEntryMetadata = this._dlFileEntryMetadataLocalService.getFileEntryMetadata(ddmStructure.getStructureId(), nextDLFileVersion.getFileVersionId());
                DDMFormValues previousDDMFormValues = this._ddmStorageEngineManager.getDDMFormValues(previousFileEntryMetadata.getDDMStorageId());
                if (previousDDMFormValues.equals((Object)(nextDDMFormValues = this._ddmStorageEngineManager.getDDMFormValues(nextFileEntryMetadata.getDDMStorageId())))) continue;
                return true;
            }
            return false;
        }
        catch (PortalException portalException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)portalException);
            }
            return false;
        }
    }

    private boolean _isExpandoUpdated(DLFileVersion previousDLFileVersion, DLFileVersion nextDLFileVersion) {
        Map nextAttributes;
        ExpandoBridge previousExpandoBridge = previousDLFileVersion.getExpandoBridge();
        ExpandoBridge nextExpandoBridge = nextDLFileVersion.getExpandoBridge();
        Map previousAttributes = previousExpandoBridge.getAttributes();
        return !previousAttributes.equals(nextAttributes = nextExpandoBridge.getAttributes());
    }
}

