/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.convert.document.library;

import com.liferay.document.library.kernel.store.Store;
import com.liferay.portal.convert.documentlibrary.DLStoreConvertProcess;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.util.MaintenanceUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DLStoreConvertProcess.class})
public class DLPreviewableProcessorDLStoreConvertProcess
implements DLStoreConvertProcess {
    private static final Log _log = LogFactoryUtil.getLog(DLPreviewableProcessorDLStoreConvertProcess.class);
    @Reference
    private CompanyLocalService _companyLocalService;

    public void copy(Store sourceStore, Store targetStore) throws PortalException {
        this._transfer(sourceStore, targetStore, "document_thumbnail/", false);
        this._transfer(sourceStore, targetStore, "document_preview/", false);
    }

    public void move(Store sourceStore, Store targetStore) throws PortalException {
        this._transfer(sourceStore, targetStore, "document_thumbnail/", true);
        this._transfer(sourceStore, targetStore, "document_preview/", true);
    }

    private void _transfer(Store sourceStore, Store targetStore, String path, boolean delete) throws PortalException {
        MaintenanceUtil.appendStatus((String)("Migrating files from " + path));
        this._companyLocalService.forEachCompanyId(companyId -> {
            String[] fileNames;
            for (String fileName : fileNames = sourceStore.getFileNames(companyId.longValue(), 0L, path)) {
                String actualFileName = StringUtil.replace((String)fileName, (String)"//", (String)"/");
                try {
                    this.transferFile(sourceStore, targetStore, (long)companyId, 0L, actualFileName, "1.0", delete);
                }
                catch (Exception exception) {
                    _log.error((Object)("Unable to migrate " + fileName), (Throwable)exception);
                }
            }
        });
    }
}

