/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.convert.document.library;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFolderConstants;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.document.library.kernel.service.DLFileVersionLocalService;
import com.liferay.document.library.kernel.store.Store;
import com.liferay.portal.convert.documentlibrary.DLStoreConvertProcess;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.util.MaintenanceUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DLStoreConvertProcess.class})
public class DLFileVersionDLStoreConvertProcess
implements DLStoreConvertProcess {
    private static final Log _log = LogFactoryUtil.getLog(DLFileVersionDLStoreConvertProcess.class);
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private DLFileEntryLocalService _dlFileEntryLocalService;
    @Reference
    private DLFileVersionLocalService _dlFileVersionLocalService;

    public void copy(Store sourceStore, Store targetStore) throws PortalException {
        this._transfer(sourceStore, targetStore, false);
    }

    public void move(Store sourceStore, Store targetStore) throws PortalException {
        this._transfer(sourceStore, targetStore, true);
    }

    private ActionableDynamicQuery _getActionableDynamicQuery(long companyId, Store sourceStore, Store targetStore, boolean delete) {
        ActionableDynamicQuery actionableDynamicQuery = this._dlFileVersionLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"companyId", (Object)companyId)));
        actionableDynamicQuery.setPerformActionMethod(dlFileVersion -> {
            DLFileEntry dlFileEntry = this._dlFileEntryLocalService.fetchDLFileEntry(dlFileVersion.getFileEntryId());
            if (dlFileEntry == null) {
                return;
            }
            long repositoryId = DLFolderConstants.getDataRepositoryId((long)dlFileVersion.getRepositoryId(), (long)dlFileVersion.getFolderId());
            try {
                this.transferFile(sourceStore, targetStore, dlFileVersion.getCompanyId(), repositoryId, dlFileEntry.getName(), dlFileVersion.getStoreFileName(), delete);
            }
            catch (Exception exception) {
                _log.error((Object)("Unable to migrate " + dlFileEntry.getName()), (Throwable)exception);
            }
        });
        return actionableDynamicQuery;
    }

    private long _getCount(long companyId) {
        DynamicQuery dynamicQuery = this._dlFileVersionLocalService.dynamicQuery();
        dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"companyId", (Object)companyId));
        return this._dlFileVersionLocalService.dynamicQueryCount(dynamicQuery);
    }

    private void _transfer(Store sourceStore, Store targetStore, boolean delete) throws PortalException {
        this._companyLocalService.forEachCompanyId(companyId -> {
            MaintenanceUtil.appendStatus((String)String.format("Migrating %d documents and media files for company %d", this._getCount((long)companyId), companyId));
            ActionableDynamicQuery actionableDynamicQuery = this._getActionableDynamicQuery((long)companyId, sourceStore, targetStore, delete);
            actionableDynamicQuery.performActions();
        });
    }
}

