/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.bulk.selection;

import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.bulk.selection.BulkSelection;
import com.liferay.bulk.selection.BulkSelectionFactory;
import com.liferay.bulk.selection.EmptyBulkSelection;
import com.liferay.document.library.internal.bulk.selection.FolderFileEntryBulkSelection;
import com.liferay.document.library.internal.bulk.selection.MultipleFileEntryBulkSelection;
import com.liferay.document.library.internal.bulk.selection.SingleFileEntryBulkSelection;
import com.liferay.document.library.internal.bulk.selection.util.BulkSelectionFactoryUtil;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.document.library.util.DLAssetHelper;
import com.liferay.portal.kernel.repository.RepositoryProvider;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.document.library.kernel.model.DLFileEntry"}, service={BulkSelectionFactory.class})
public class FileEntryBulkSelectionFactory
implements BulkSelectionFactory<FileEntry> {
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private DLAppService _dlAppService;
    @Reference
    private DLAssetHelper _dlAssetHelper;
    @Reference
    private RepositoryProvider _repositoryProvider;

    public BulkSelection<FileEntry> create(Map<String, String[]> parameterMap) {
        if (BulkSelectionFactoryUtil.isSelectAll(parameterMap)) {
            return new FolderFileEntryBulkSelection(BulkSelectionFactoryUtil.getRepositoryId(parameterMap), BulkSelectionFactoryUtil.getFolderId(parameterMap), parameterMap, this._repositoryProvider, this._dlAppService, this._assetEntryLocalService, this._dlAssetHelper);
        }
        if (!parameterMap.containsKey("rowIdsFileEntry")) {
            return new EmptyBulkSelection();
        }
        String[] values = parameterMap.get("rowIdsFileEntry");
        return this._getFileEntrySelection(values, parameterMap);
    }

    private BulkSelection<FileEntry> _getFileEntrySelection(String[] values, Map<String, String[]> parameterMap) {
        long[] fileEntryIds;
        if (values.length == 1) {
            values = StringUtil.split((String)values[0]);
        }
        if ((fileEntryIds = GetterUtil.getLongValues((String[])values)).length == 1) {
            return new SingleFileEntryBulkSelection(fileEntryIds[0], parameterMap, this._dlAppService, this._assetEntryLocalService, this._dlAssetHelper);
        }
        return new MultipleFileEntryBulkSelection(fileEntryIds, parameterMap, this._dlAppService, this._assetEntryLocalService, this._dlAssetHelper);
    }
}

