/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.osgi.commands;

import com.liferay.document.library.kernel.service.DLFileVersionLocalService;
import com.liferay.document.library.kernel.store.StoreAreaProcessor;
import com.liferay.document.library.service.DLStorageQuotaLocalService;
import com.liferay.osgi.util.osgi.commands.OSGiCommands;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.util.PropsValues;
import java.time.Duration;
import java.time.temporal.TemporalAmount;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTracker;

@Component(property={"osgi.command.function=cleanUp", "osgi.command.function=update", "osgi.command.scope=documentLibrary"}, service={OSGiCommands.class})
public class DocumentLibraryOSGiCommands
implements OSGiCommands {
    private static final Log _log = LogFactoryUtil.getLog(DocumentLibraryOSGiCommands.class);
    @Reference
    private DLFileVersionLocalService _dlFileVersionLocalService;
    @Reference
    private DLStorageQuotaLocalService _dlStorageQuotaLocalService;
    private ServiceTracker<StoreAreaProcessor, StoreAreaProcessor> _serviceTracker;

    public void cleanUp(long companyId) {
        StoreAreaProcessor storeAreaProcessor = (StoreAreaProcessor)this._serviceTracker.getService();
        if (storeAreaProcessor == null) {
            System.out.println("Do nothing because the selected store " + PropsValues.DL_STORE_IMPL + " does not support store areas.");
            return;
        }
        storeAreaProcessor.cleanUpDeletedStoreArea(companyId, Integer.MAX_VALUE, name -> !this._isDLFileVersionReferenced(companyId, (String)name), "", (TemporalAmount)Duration.ofSeconds(1L));
        storeAreaProcessor.cleanUpNewStoreArea(companyId, Integer.MAX_VALUE, name -> !this._isDLFileVersionReferenced(companyId, (String)name), "", (TemporalAmount)Duration.ofSeconds(1L));
    }

    public void update(String ... companyIds) {
        for (String companyId : companyIds) {
            try {
                this._dlStorageQuotaLocalService.updateStorageSize(GetterUtil.getLong((String)companyId));
                System.out.printf("Successfully updated document library storage quota for company %s%n", companyId);
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
                System.out.printf("Unable to update document library storage quota for company %s. See server log for more details.%n", companyId);
            }
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) throws InvalidSyntaxException {
        this._serviceTracker = new ServiceTracker(bundleContext, bundleContext.createFilter(StringBundler.concat((String[])new String[]{"(&(objectClass=", StoreAreaProcessor.class.getName(), ")(store.type=", PropsValues.DL_STORE_IMPL, "))"})), null);
        this._serviceTracker.open();
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTracker.close();
    }

    private boolean _isDLFileVersionReferenced(Long companyId, String name) {
        int index = name.lastIndexOf("~");
        if (index == -1) {
            return true;
        }
        int count = this._dlFileVersionLocalService.getFileVersionsCount(companyId.longValue(), name.substring(index + 1));
        return count > 0;
    }
}

