/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.messaging;

import com.liferay.document.library.internal.configuration.StoreAreaConfiguration;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationConfiguration;
import com.liferay.portal.kernel.messaging.DestinationFactory;
import com.liferay.portal.kernel.util.MapUtil;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.document.library.internal.configuration.StoreAreaConfiguration"}, service={})
public class DLDeletionMessagingConfigurator {
    @Reference
    private DestinationFactory _destinationFactory;
    private ServiceRegistration<Destination> _destinationServiceRegistration;

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        DestinationConfiguration destinationConfiguration = DestinationConfiguration.createSerialDestinationConfiguration((String)"liferay/document_library_deletion");
        StoreAreaConfiguration storeAreaConfiguration = (StoreAreaConfiguration)ConfigurableUtil.createConfigurable(StoreAreaConfiguration.class, properties);
        int maxDeletionQueueSize = storeAreaConfiguration.maxDeletionQueueSize();
        if (maxDeletionQueueSize <= 0) {
            maxDeletionQueueSize = Integer.MAX_VALUE;
        }
        destinationConfiguration.setMaximumQueueSize(maxDeletionQueueSize);
        Destination destination = this._destinationFactory.createDestination(destinationConfiguration);
        this._destinationServiceRegistration = bundleContext.registerService(Destination.class, (Object)destination, MapUtil.singletonDictionary((Object)"destination.name", (Object)destination.getName()));
    }

    @Deactivate
    protected void deactivate() {
        if (this._destinationServiceRegistration != null) {
            this._destinationServiceRegistration.unregister();
        }
    }
}

