/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.bulk.selection;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.bulk.selection.BulkSelection;
import com.liferay.bulk.selection.BulkSelectionFactory;
import com.liferay.document.library.internal.bulk.selection.BaseFolderEntryBulkSelection;
import com.liferay.document.library.internal.bulk.selection.FileEntryAssetEntryBulkSelection;
import com.liferay.document.library.internal.bulk.selection.FileEntryBulkSelectionFactory;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.document.library.util.DLAssetHelper;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.RepositoryProvider;
import com.liferay.portal.kernel.repository.model.BaseRepositoryModelOperation;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.RepositoryModelOperation;
import java.util.Map;

public class FolderFileEntryBulkSelection
extends BaseFolderEntryBulkSelection<FileEntry> {
    private final AssetEntryLocalService _assetEntryLocalService;
    private final DLAppService _dlAppService;
    private final DLAssetHelper _dlAssetHelper;
    private final long _folderId;
    private final long _repositoryId;

    public FolderFileEntryBulkSelection(long repositoryId, long folderId, Map<String, String[]> parameterMap, RepositoryProvider repositoryProvider, DLAppService dlAppService, AssetEntryLocalService assetEntryLocalService, DLAssetHelper dlAssetHelper) {
        super(repositoryId, folderId, parameterMap, repositoryProvider);
        this._repositoryId = repositoryId;
        this._folderId = folderId;
        this._dlAppService = dlAppService;
        this._assetEntryLocalService = assetEntryLocalService;
        this._dlAssetHelper = dlAssetHelper;
    }

    public Class<? extends BulkSelectionFactory> getBulkSelectionFactoryClass() {
        return FileEntryBulkSelectionFactory.class;
    }

    public long getSize() throws PortalException {
        return this._dlAppService.getFileEntriesCount(this._repositoryId, this._folderId);
    }

    public BulkSelection<AssetEntry> toAssetEntryBulkSelection() {
        return new FileEntryAssetEntryBulkSelection((BulkSelection<FileEntry>)this, this._assetEntryLocalService, this._dlAssetHelper);
    }

    @Override
    protected <E extends PortalException> RepositoryModelOperation getRepositoryModelOperation(final UnsafeConsumer<? super FileEntry, E> action) {
        return new BaseRepositoryModelOperation(){

            public void execute(FileEntry fileEntry) throws PortalException {
                action.accept((Object)fileEntry);
            }
        };
    }
}

