/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.model.listener;

import com.liferay.document.library.internal.util.DLExportableRepositoryPublisherUtil;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.staging.model.listener.StagingModelListener;
import java.util.Collection;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class DLFileVersionStagingModelListener
extends BaseModelListener<DLFileVersion> {
    private static final Log _log = LogFactoryUtil.getLog(DLFileVersionStagingModelListener.class);
    @Reference
    private StagingModelListener<DLFileEntry> _stagingModelListener;

    public void onAfterCreate(DLFileVersion dlFileVersion) throws ModelListenerException {
        if (dlFileVersion.getStatus() != 0) {
            return;
        }
        DLFileEntry dlFileEntry = null;
        try {
            dlFileEntry = dlFileVersion.getFileEntry();
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
            return;
        }
        Collection<Long> exportableRepositoryIds = DLExportableRepositoryPublisherUtil.publish(dlFileEntry.getGroupId());
        if (!exportableRepositoryIds.contains(dlFileEntry.getRepositoryId())) {
            return;
        }
        this._stagingModelListener.onAfterCreate((BaseModel)dlFileEntry);
    }

    public void onAfterUpdate(DLFileVersion originalDLFileVersion, DLFileVersion dlFileVersion) throws ModelListenerException {
        if (dlFileVersion.getStatus() != 0 && dlFileVersion.getStatus() != 8) {
            return;
        }
        DLFileEntry dlFileEntry = null;
        try {
            dlFileEntry = dlFileVersion.getFileEntry();
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
            return;
        }
        Collection<Long> exportableRepositoryIds = DLExportableRepositoryPublisherUtil.publish(dlFileEntry.getGroupId());
        if (!exportableRepositoryIds.contains(dlFileEntry.getRepositoryId())) {
            return;
        }
        this._stagingModelListener.onAfterUpdate((BaseModel)dlFileEntry);
    }
}

