/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.messaging;

import com.liferay.portal.convert.ConvertProcess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationConfiguration;
import com.liferay.portal.kernel.messaging.DestinationFactory;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.util.ShutdownUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(property={"destination.name=liferay/convert_process"}, service={MessageListener.class})
public class ConvertProcessMessageListener
implements MessageListener {
    private static final Log _log = LogFactoryUtil.getLog(ConvertProcessMessageListener.class);
    @Reference
    private DestinationFactory _destinationFactory;
    private ServiceRegistration<Destination> _serviceRegistration;

    public void receive(Message message) {
        try {
            this.doReceive(message);
        }
        catch (Exception exception) {
            _log.fatal((Object)("Unable to process message " + String.valueOf(message)), (Throwable)exception);
            ShutdownUtil.shutdown((long)0L);
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        Destination destination = this._destinationFactory.createDestination(new DestinationConfiguration("serial", "liferay/convert_process"));
        this._serviceRegistration = bundleContext.registerService(Destination.class, (Object)destination, MapUtil.singletonDictionary((Object)"destination.name", (Object)destination.getName()));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceRegistration.unregister();
    }

    protected void doReceive(Message message) throws Exception {
        ConvertProcess convertProcess = (ConvertProcess)message.getPayload();
        convertProcess.convert();
    }
}

