/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.convert.document.library;

import com.liferay.document.library.kernel.store.Store;
import com.liferay.portal.convert.documentlibrary.DLStoreConvertProcess;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.util.MaintenanceUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DLStoreConvertProcess.class})
public class DLKeyStoreManagerDLStoreConvertProcess
implements DLStoreConvertProcess {
    private static final String _SAML_KEYSTORE_PATH = "saml/keystore.jks";
    private static final Log _log = LogFactoryUtil.getLog(DLKeyStoreManagerDLStoreConvertProcess.class);
    @Reference
    private CompanyLocalService _companyLocalService;

    public void copy(Store sourceStore, Store targetStore) throws PortalException {
        this._transfer(sourceStore, targetStore, _SAML_KEYSTORE_PATH, false);
    }

    public void move(Store sourceStore, Store targetStore) throws PortalException {
        this._transfer(sourceStore, targetStore, _SAML_KEYSTORE_PATH, true);
    }

    private void _transfer(Store sourceStore, Store targetStore, String path, boolean delete) throws PortalException {
        MaintenanceUtil.appendStatus((String)("Migrating files from " + path));
        this._companyLocalService.forEachCompanyId(companyId -> {
            if (sourceStore.hasFile(companyId.longValue(), 0L, _SAML_KEYSTORE_PATH, "1.0")) {
                try {
                    this.transferFile(sourceStore, targetStore, (long)companyId, 0L, _SAML_KEYSTORE_PATH, "1.0", delete);
                }
                catch (Exception exception) {
                    _log.error((Object)"Unable to migrate saml/keystore.jks", (Throwable)exception);
                }
            }
        });
    }
}

