/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.bulk.selection;

import com.liferay.bulk.selection.BaseContainerEntryBulkSelection;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.RepositoryProvider;
import com.liferay.portal.kernel.repository.capabilities.BulkOperationCapability;
import com.liferay.portal.kernel.repository.model.RepositoryModel;
import com.liferay.portal.kernel.repository.model.RepositoryModelOperation;
import java.util.Map;

public abstract class BaseFolderEntryBulkSelection<T extends RepositoryModel<T>>
extends BaseContainerEntryBulkSelection<T> {
    private final long _folderId;
    private final long _repositoryId;
    private final RepositoryProvider _repositoryProvider;

    public BaseFolderEntryBulkSelection(long repositoryId, long folderId, Map<String, String[]> parameterMap, RepositoryProvider repositoryProvider) {
        super(folderId, parameterMap);
        this._repositoryId = repositoryId;
        this._folderId = folderId;
        this._repositoryProvider = repositoryProvider;
    }

    public <E extends PortalException> void forEach(UnsafeConsumer<T, E> unsafeConsumer) throws PortalException {
        LocalRepository documentRepository = this._repositoryProvider.getLocalRepository(this._repositoryId);
        if (!documentRepository.isCapabilityProvided(BulkOperationCapability.class)) {
            return;
        }
        BulkOperationCapability bulkOperationCapability = (BulkOperationCapability)documentRepository.getCapability(BulkOperationCapability.class);
        BulkOperationCapability.Filter bulkFilter = new BulkOperationCapability.Filter(BulkOperationCapability.Field.FolderId.class, BulkOperationCapability.Operator.EQ, (Object)this._folderId);
        bulkOperationCapability.execute(bulkFilter, this.getRepositoryModelOperation(unsafeConsumer));
    }

    protected abstract <E extends PortalException> RepositoryModelOperation getRepositoryModelOperation(UnsafeConsumer<? super T, E> var1);
}

