/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.convert.document.library;

import com.liferay.document.library.kernel.store.Store;
import com.liferay.portal.convert.documentlibrary.DLStoreConvertProcess;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ImageLocalService;
import com.liferay.portal.util.MaintenanceUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DLStoreConvertProcess.class})
public class ImageDLStoreConvertProcess
implements DLStoreConvertProcess {
    private static final Log _log = LogFactoryUtil.getLog(ImageDLStoreConvertProcess.class);
    @Reference
    private ImageLocalService _imageLocalService;

    public void copy(Store sourceStore, Store targetStore) throws PortalException {
        this._transfer(sourceStore, targetStore, false);
    }

    public void move(Store sourceStore, Store targetStore) throws PortalException {
        this._transfer(sourceStore, targetStore, true);
    }

    private void _transfer(Store sourceStore, Store targetStore, boolean delete) throws PortalException {
        int count = this._imageLocalService.getImagesCount();
        MaintenanceUtil.appendStatus((String)("Migrating " + count + " images"));
        ActionableDynamicQuery actionableDynamicQuery = this._imageLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setPerformActionMethod(image -> {
            String fileName = image.getImageId() + "." + image.getType();
            try {
                this.transferFile(sourceStore, targetStore, 0L, 0L, fileName, "1.0", delete);
            }
            catch (Exception exception) {
                _log.error((Object)("Unable to migrate " + fileName), (Throwable)exception);
            }
        });
        actionableDynamicQuery.performActions();
    }
}

