/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.bulk.selection;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.bulk.selection.BulkSelection;
import com.liferay.bulk.selection.BulkSelectionFactory;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.repository.model.RepositoryModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.portal.kernel.repository.model.RepositoryModel"}, service={BulkSelectionFactory.class, RepositoryModelBulkSelectionFactory.class})
public class RepositoryModelBulkSelectionFactory
implements BulkSelectionFactory<RepositoryModel<?>> {
    @Reference(target="(model.class.name=com.liferay.document.library.kernel.model.DLFileEntry)")
    private BulkSelectionFactory<FileEntry> _fileEntryBulkSelectionFactory;
    @Reference(target="(model.class.name=com.liferay.document.library.kernel.model.DLFileShortcut)")
    private BulkSelectionFactory<FileShortcut> _fileShortcutBulkSelectionFactory;
    @Reference(target="(model.class.name=com.liferay.document.library.kernel.model.DLFolder)")
    private BulkSelectionFactory<Folder> _folderBulkSelectionFactory;

    public BulkSelection<RepositoryModel<?>> create(Map<String, String[]> parameterMap) {
        return this._combine(parameterMap, this._fileEntryBulkSelectionFactory.create(parameterMap), this._fileShortcutBulkSelectionFactory.create(parameterMap), this._folderBulkSelectionFactory.create(parameterMap));
    }

    private BulkSelection<RepositoryModel<?>> _combine(final Map<String, String[]> parameterMap, final BulkSelection<? extends RepositoryModel<?>> ... bulkSelections) {
        return new BulkSelection<RepositoryModel<?>>(){

            public <E extends PortalException> void forEach(UnsafeConsumer<RepositoryModel<?>, E> unsafeConsumer) throws PortalException {
                BulkSelection[] bulkSelectionArray = bulkSelections;
                int n = bulkSelectionArray.length;
                for (int i = 0; i < n; ++i) {
                    BulkSelection bulkSelection;
                    BulkSelection repositoryBulkSelection = bulkSelection = bulkSelectionArray[i];
                    repositoryBulkSelection.forEach(unsafeConsumer);
                }
            }

            public Class<? extends BulkSelectionFactory> getBulkSelectionFactoryClass() {
                return RepositoryModelBulkSelectionFactory.class;
            }

            public Map<String, String[]> getParameterMap() {
                return parameterMap;
            }

            public long getSize() throws PortalException {
                long size = 0L;
                for (BulkSelection bulkSelection : bulkSelections) {
                    size += bulkSelection.getSize();
                }
                return size;
            }

            public Serializable serialize() {
                return null;
            }

            public BulkSelection<AssetEntry> toAssetEntryBulkSelection() {
                ArrayList<BulkSelection> assetEntryBulkSelections = new ArrayList<BulkSelection>();
                for (BulkSelection bulkSelection : bulkSelections) {
                    assetEntryBulkSelections.add(bulkSelection.toAssetEntryBulkSelection());
                }
                return RepositoryModelBulkSelectionFactory.this._combine(parameterMap, assetEntryBulkSelections.toArray(new BulkSelection[0]));
            }
        };
    }
}

