/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.bulk.selection;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.bulk.selection.BaseMultipleEntryBulkSelection;
import com.liferay.bulk.selection.BulkSelection;
import com.liferay.bulk.selection.BulkSelectionFactory;
import com.liferay.document.library.internal.bulk.selection.FileShortcutBulkSelectionFactory;
import com.liferay.document.library.kernel.exception.NoSuchFolderException;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import java.util.Map;

public class MultipleFileShortcutBulkSelection
extends BaseMultipleEntryBulkSelection<FileShortcut> {
    private static final Log _log = LogFactoryUtil.getLog(MultipleFileShortcutBulkSelection.class);
    private final DLAppService _dlAppService;

    public MultipleFileShortcutBulkSelection(long[] fileShortcutIds, Map<String, String[]> parameterMap, DLAppService dlAppService) {
        super(fileShortcutIds, parameterMap);
        this._dlAppService = dlAppService;
    }

    public Class<? extends BulkSelectionFactory> getBulkSelectionFactoryClass() {
        return FileShortcutBulkSelectionFactory.class;
    }

    public BulkSelection<AssetEntry> toAssetEntryBulkSelection() {
        throw new UnsupportedOperationException("File shortcut is not an asset");
    }

    protected FileShortcut fetchEntry(long fileShortcutId) {
        try {
            return this._dlAppService.getFileShortcut(fileShortcutId);
        }
        catch (NoSuchFolderException noSuchFolderException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)noSuchFolderException, (Throwable)noSuchFolderException);
            }
            return null;
        }
        catch (PortalException portalException) {
            return (FileShortcut)ReflectionUtil.throwException((Throwable)portalException);
        }
    }
}

