/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.atom;

import com.liferay.document.library.kernel.model.DLVersionNumberIncrease;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.document.library.kernel.util.comparator.RepositoryModelTitleComparator;
import com.liferay.portal.atom.AtomPager;
import com.liferay.portal.atom.AtomUtil;
import com.liferay.portal.kernel.atom.AtomCollectionAdapter;
import com.liferay.portal.kernel.atom.AtomEntryContent;
import com.liferay.portal.kernel.atom.AtomException;
import com.liferay.portal.kernel.atom.AtomRequestContext;
import com.liferay.portal.kernel.atom.BaseMediaAtomCollectionAdapter;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.portal.kernel.repository.model.FileEntry"}, service={AtomCollectionAdapter.class})
public class FileEntryAtomCollectionAdapter
extends BaseMediaAtomCollectionAdapter<FileEntry> {
    protected static final String COLLECTION_NAME = "files";
    private DLAppService _dlAppService;

    public String getCollectionName() {
        return COLLECTION_NAME;
    }

    public List<String> getEntryAuthors(FileEntry fileEntry) {
        return ListUtil.fromArray((Object[])new String[]{fileEntry.getUserName()});
    }

    public AtomEntryContent getEntryContent(FileEntry fileEntry, AtomRequestContext atomRequestContext) {
        AtomEntryContent atomEntryContent = new AtomEntryContent(AtomEntryContent.Type.MEDIA);
        atomEntryContent.setMimeType(fileEntry.getMimeType());
        String srcLink = AtomUtil.createEntryLink((AtomRequestContext)atomRequestContext, (String)COLLECTION_NAME, (String)(fileEntry.getFileEntryId() + ":media"));
        atomEntryContent.setSrcLink(srcLink);
        return atomEntryContent;
    }

    public String getEntryId(FileEntry fileEntry) {
        return String.valueOf(fileEntry.getPrimaryKey());
    }

    public String getEntrySummary(FileEntry fileEntry) {
        return fileEntry.getDescription();
    }

    public String getEntryTitle(FileEntry fileEntry) {
        return fileEntry.getTitle();
    }

    public Date getEntryUpdated(FileEntry fileEntry) {
        return fileEntry.getModifiedDate();
    }

    public String getFeedTitle(AtomRequestContext atomRequestContext) {
        String portletId = PortletProviderUtil.getPortletId((String)FileEntry.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW);
        String feedTitleFromPortletName = AtomUtil.createFeedTitleFromPortletName((AtomRequestContext)atomRequestContext, (String)portletId);
        return feedTitleFromPortletName + " files";
    }

    public String getMediaContentType(FileEntry fileEntry) {
        return fileEntry.getMimeType();
    }

    public String getMediaName(FileEntry fileEntry) {
        return fileEntry.getTitle();
    }

    public InputStream getMediaStream(FileEntry fileEntry) throws AtomException {
        try {
            return fileEntry.getContentStream();
        }
        catch (Exception exception) {
            throw new AtomException(500, (Throwable)exception);
        }
    }

    protected void doDeleteEntry(String resourceName, AtomRequestContext atomRequestContext) throws Exception {
        long fileEntryId = GetterUtil.getLong((String)resourceName);
        this._dlAppService.deleteFileEntry(fileEntryId);
    }

    protected FileEntry doGetEntry(String resourceName, AtomRequestContext atomRequestContext) throws Exception {
        long fileEntryId = GetterUtil.getLong((String)resourceName);
        return this._dlAppService.getFileEntry(fileEntryId);
    }

    protected Iterable<FileEntry> doGetFeedEntries(AtomRequestContext atomRequestContext) throws Exception {
        long folderId = atomRequestContext.getLongParameter("folderId");
        long repositoryId = 0L;
        if (folderId != 0L) {
            Folder folder = this._dlAppService.getFolder(folderId);
            repositoryId = folder.getRepositoryId();
        } else {
            repositoryId = atomRequestContext.getLongParameter("repositoryId");
        }
        int count = this._dlAppService.getFileEntriesCount(repositoryId, folderId);
        AtomPager atomPager = new AtomPager(atomRequestContext, count);
        AtomUtil.saveAtomPagerInRequest((AtomRequestContext)atomRequestContext, (AtomPager)atomPager);
        return this._dlAppService.getFileEntries(repositoryId, folderId, atomPager.getStart(), atomPager.getEnd() + 1, (OrderByComparator)new RepositoryModelTitleComparator());
    }

    protected FileEntry doPostEntry(String title, String summary, String content, Date date, AtomRequestContext atomRequestContext) throws Exception {
        long folderId = atomRequestContext.getLongParameter("folderId");
        long repositoryId = 0L;
        if (folderId != 0L) {
            Folder folder = this._dlAppService.getFolder(folderId);
            repositoryId = folder.getRepositoryId();
        } else {
            repositoryId = atomRequestContext.getLongParameter("repositoryId");
        }
        String mimeType = atomRequestContext.getHeader("Media-Content-Type");
        if (mimeType == null) {
            mimeType = MimeTypesUtil.getContentType((String)title);
        }
        byte[] contentDecoded = Base64.decode((String)content);
        ByteArrayInputStream contentByteArrayInputStream = new ByteArrayInputStream(contentDecoded);
        ServiceContext serviceContext = new ServiceContext();
        return this._dlAppService.addFileEntry(repositoryId, folderId, title, mimeType, title, summary, null, (InputStream)contentByteArrayInputStream, (long)contentDecoded.length, serviceContext);
    }

    protected FileEntry doPostMedia(String mimeType, String slug, InputStream inputStream, AtomRequestContext atomRequestContext) throws Exception {
        long folderId = atomRequestContext.getLongParameter("folderId");
        long repositoryId = 0L;
        if (folderId != 0L) {
            Folder folder = this._dlAppService.getFolder(folderId);
            repositoryId = folder.getRepositoryId();
        } else {
            repositoryId = atomRequestContext.getLongParameter("repositoryId");
        }
        String title = atomRequestContext.getHeader("Title");
        String description = atomRequestContext.getHeader("Summary");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamUtil.transfer((InputStream)inputStream, (OutputStream)byteArrayOutputStream);
        byte[] content = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream contentByteArrayInputStream = new ByteArrayInputStream(content);
        ServiceContext serviceContext = new ServiceContext();
        return this._dlAppService.addFileEntry(repositoryId, folderId, title, mimeType, title, description, null, (InputStream)contentByteArrayInputStream, (long)content.length, serviceContext);
    }

    protected void doPutEntry(FileEntry fileEntry, String title, String summary, String content, Date date, AtomRequestContext atomRequestContext) throws Exception {
        String mimeType = atomRequestContext.getHeader("Media-Content-Type");
        if (mimeType == null) {
            mimeType = MimeTypesUtil.getContentType((String)title);
        }
        byte[] contentDecoded = Base64.decode((String)content);
        ByteArrayInputStream contentByteArrayInputStream = new ByteArrayInputStream(contentDecoded);
        ServiceContext serviceContext = new ServiceContext();
        this._dlAppService.updateFileEntry(fileEntry.getFileEntryId(), title, mimeType, title, summary, null, DLVersionNumberIncrease.MAJOR, (InputStream)contentByteArrayInputStream, (long)contentDecoded.length, serviceContext);
    }

    protected void doPutMedia(FileEntry fileEntry, String mimeType, String slug, InputStream inputStream, AtomRequestContext atomRequestContext) throws Exception {
        String title = atomRequestContext.getHeader("Title");
        String description = atomRequestContext.getHeader("Summary");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamUtil.transfer((InputStream)inputStream, (OutputStream)byteArrayOutputStream);
        byte[] content = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream contentByteArrayInputStream = new ByteArrayInputStream(content);
        ServiceContext serviceContext = new ServiceContext();
        this._dlAppService.updateFileEntry(fileEntry.getFileEntryId(), slug, mimeType, title, description, null, DLVersionNumberIncrease.MAJOR, (InputStream)contentByteArrayInputStream, (long)content.length, serviceContext);
    }

    @Reference(unbind="-")
    protected void setDLAppService(DLAppService dlAppService) {
        this._dlAppService = dlAppService;
    }
}

