/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.jsontoken.crypto;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import net.oauth.jsontoken.crypto.AbstractSigner;
import net.oauth.jsontoken.crypto.SignatureAlgorithm;

public class HmacSHA256Signer
extends AbstractSigner {
    private static final String HMAC_SHA256_ALG = "HmacSHA256";
    private final Mac hmac;
    private final SecretKey signingKey;

    public HmacSHA256Signer(String issuer, String keyId, byte[] keyBytes) throws InvalidKeyException {
        super(issuer, keyId);
        this.signingKey = new SecretKeySpec(keyBytes, HMAC_SHA256_ALG);
        try {
            this.hmac = Mac.getInstance(HMAC_SHA256_ALG);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("cannot use Hmac256Signer on system without HmacSHA256 alg", e);
        }
        this.hmac.init(this.signingKey);
    }

    @Override
    public byte[] sign(byte[] source) {
        try {
            this.hmac.init(this.signingKey);
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException("key somehow became invalid since calling the constructor", e);
        }
        return this.hmac.doFinal(source);
    }

    @Override
    public SignatureAlgorithm getSignatureAlgorithm() {
        return SignatureAlgorithm.HS256;
    }
}

