/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.signatures;

import com.google.common.base.Preconditions;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import net.oauth.jsontoken.Clock;
import net.oauth.jsontoken.JsonToken;
import net.oauth.jsontoken.crypto.Signer;
import org.apache.commons.codec.binary.Base64;

public class SignedOAuthToken
extends JsonToken {
    public static final String AUTH_METHOD = "Token";
    public static final String SIGNED_TOKEN_PARAM = "signed_token";
    public static final String METHOD = "method";
    public static final String BODY_HASH = "body_hash";
    public static final String OAUTH_TOKEN = "token";
    public static final String NONCE = "nonce";

    public SignedOAuthToken(Signer signer, Clock clock) {
        super(signer, clock);
    }

    public SignedOAuthToken(Signer signer) {
        super(signer);
    }

    public SignedOAuthToken(JsonToken token) {
        super(token.getPayloadAsJsonObject());
    }

    public String getMethod() {
        return this.getParamAsPrimitive(METHOD).getAsString();
    }

    public void setMethod(String m) {
        this.setParam(METHOD, m);
    }

    public String getBodyHash() {
        return this.getParamAsPrimitive(BODY_HASH).getAsString();
    }

    public void setRequestBody(byte[] body) {
        this.setParam(BODY_HASH, this.getBodyHash(body));
    }

    public String getOAuthToken() {
        return this.getParamAsPrimitive(OAUTH_TOKEN).getAsString();
    }

    public void setOAuthToken(String t) {
        this.setParam(OAUTH_TOKEN, t);
    }

    public String getNonce() {
        return this.getParamAsPrimitive(NONCE).getAsString();
    }

    public void setNonce(String n) {
        this.setParam(NONCE, n);
    }

    public String getAuthorizationHeader() throws SignatureException {
        return "Token signed_token=" + this.serializeAndSign();
    }

    @Override
    public String serializeAndSign() throws SignatureException {
        Preconditions.checkNotNull(this.getOAuthToken(), "must set OAuth token");
        Preconditions.checkNotNull(this.getNonce(), "must set nonce");
        Preconditions.checkNotNull(this.getAudience(), "must set Audience");
        Preconditions.checkNotNull(this.getMethod(), "must set method");
        return super.serializeAndSign();
    }

    private String getBodyHash(byte[] requestBody) {
        MessageDigest digest;
        Preconditions.checkNotNull(requestBody);
        String hashAlg = this.getSignatureAlgorithm().getHashAlgorithm();
        try {
            digest = MessageDigest.getInstance(hashAlg);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("platform is missing hash algorithm: " + hashAlg);
        }
        byte[] hash = digest.digest(requestBody);
        return Base64.encodeBase64URLSafeString((byte[])hash);
    }
}

