/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.document.conversion.internal.security.auth.verifier;

import com.liferay.document.library.document.conversion.internal.ImageRequestTokenUtil;
import com.liferay.portal.kernel.security.auth.AccessControlContext;
import com.liferay.portal.kernel.security.auth.AuthException;
import com.liferay.portal.kernel.security.auth.verifier.AuthVerifier;
import com.liferay.portal.kernel.security.auth.verifier.AuthVerifierResult;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class ImageRequestAuthVerifier
implements AuthVerifier {
    public String getAuthType() {
        Class<?> clazz = this.getClass();
        return clazz.getSimpleName();
    }

    public AuthVerifierResult verify(AccessControlContext accessControlContext, Properties properties) throws AuthException {
        AuthVerifierResult authVerifierResult = new AuthVerifierResult();
        HttpServletRequest httpServletRequest = accessControlContext.getRequest();
        try {
            String token = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"auth_token");
            if (Validator.isBlank((String)token)) {
                return authVerifierResult;
            }
            long userId = ImageRequestTokenUtil.getUserId(token);
            if (userId != 0L) {
                authVerifierResult.setState(AuthVerifierResult.State.SUCCESS);
                authVerifierResult.setUserId(userId);
            } else {
                authVerifierResult.setState(AuthVerifierResult.State.INVALID_CREDENTIALS);
            }
            return authVerifierResult;
        }
        catch (Exception exception) {
            throw new AuthException((Throwable)exception);
        }
    }
}

