/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.depot.service.impl;

import com.liferay.depot.exception.DepotEntryGroupException;
import com.liferay.depot.exception.DepotEntryNameException;
import com.liferay.depot.exception.DepotEntryStagedException;
import com.liferay.depot.model.DepotEntry;
import com.liferay.depot.model.DepotEntryGroupRel;
import com.liferay.depot.model.DepotEntryTable;
import com.liferay.depot.service.DepotAppCustomizationLocalService;
import com.liferay.depot.service.DepotEntryPinLocalService;
import com.liferay.depot.service.base.DepotEntryLocalServiceBaseImpl;
import com.liferay.depot.service.persistence.DepotEntryGroupRelPersistence;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.GroupKeyException;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Groups_UserGroupsTable;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.Users_GroupsTable;
import com.liferay.portal.kernel.model.Users_UserGroupsTable;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserGroupRoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portal.kernel.util.Validator;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.depot.model.DepotEntry"}, service={AopService.class})
public class DepotEntryLocalServiceImpl
extends DepotEntryLocalServiceBaseImpl {
    private static final String _ORGANIZATION_NAME_SUFFIX = " LFR_ORGANIZATION";
    @Reference
    private DepotAppCustomizationLocalService _depotAppCustomizationLocalService;
    @Reference
    private DepotEntryGroupRelPersistence _depotEntryGroupRelPersistence;
    @Reference
    private DepotEntryPinLocalService _depotEntryPinLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Language _language;
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private UserGroupRoleLocalService _userGroupRoleLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public DepotEntry addDepotEntry(Group group, ServiceContext serviceContext) throws PortalException {
        if (!group.isDepot() || !ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"staging")) {
            throw new DepotEntryGroupException("Unable to create staged depot entry for group " + group.getGroupId());
        }
        this._validateNameMap(group.getNameMap(), LocaleUtil.getDefault());
        DepotEntry depotEntry = this.depotEntryPersistence.create(this.counterLocalService.increment());
        depotEntry.setUuid(serviceContext.getUuid());
        depotEntry.setGroupId(group.getGroupId());
        depotEntry.setCompanyId(serviceContext.getCompanyId());
        depotEntry.setUserId(serviceContext.getUserId());
        depotEntry.setType(GetterUtil.getInteger((String)group.getTypeSettingsProperty("depotEntryType"), (int)0));
        depotEntry = (DepotEntry)this.depotEntryPersistence.update((BaseModel)depotEntry);
        this._resourceLocalService.addResources(serviceContext.getCompanyId(), 0L, serviceContext.getUserId(), DepotEntry.class.getName(), depotEntry.getDepotEntryId(), false, false, false);
        return depotEntry;
    }

    public DepotEntry addDepotEntry(Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, int type, ServiceContext serviceContext) throws PortalException {
        this._validateNameMap(nameMap, LocaleUtil.getDefault());
        DepotEntry depotEntry = this.depotEntryPersistence.create(this.counterLocalService.increment());
        depotEntry.setUuid(serviceContext.getUuid());
        Group group = this._groupLocalService.addGroup("", serviceContext.getUserId(), 0L, DepotEntry.class.getName(), depotEntry.getDepotEntryId(), 0L, nameMap, descriptionMap, 5, null, true, 0, "/asset-library-" + depotEntry.getDepotEntryId(), false, false, true, serviceContext);
        this._groupLocalService.updateGroup(group.getGroupId(), UnicodePropertiesBuilder.create((Map)group.getTypeSettingsProperties(), (boolean)true).put("depotEntryType", type).buildString());
        this._userLocalService.addGroupUsers(group.getGroupId(), new long[]{serviceContext.getUserId()});
        User user = this._userLocalService.getUser(serviceContext.getUserId());
        if (!user.isGuestUser()) {
            Role role = this._roleLocalService.getRole(group.getCompanyId(), "Asset Library Owner");
            this._userGroupRoleLocalService.addUserGroupRoles(user.getUserId(), group.getGroupId(), new long[]{role.getRoleId()});
            this._userLocalService.addGroupUsers(group.getGroupId(), new long[]{user.getUserId()});
        }
        depotEntry.setGroupId(group.getGroupId());
        depotEntry.setCompanyId(serviceContext.getCompanyId());
        depotEntry.setUserId(serviceContext.getUserId());
        depotEntry.setType(type);
        depotEntry = (DepotEntry)this.depotEntryPersistence.update((BaseModel)depotEntry);
        this._resourceLocalService.addResources(serviceContext.getCompanyId(), 0L, serviceContext.getUserId(), DepotEntry.class.getName(), depotEntry.getDepotEntryId(), false, false, false);
        return depotEntry;
    }

    @Override
    public DepotEntry deleteDepotEntry(DepotEntry depotEntry) throws PortalException {
        if (this._isStaged(depotEntry)) {
            throw new DepotEntryStagedException("Unstage depot entry " + depotEntry.getDepotEntryId() + " before deleting it");
        }
        this.depotEntryPersistence.remove((BaseModel)depotEntry);
        this._resourceLocalService.deleteResource((AuditedModel)depotEntry, 4);
        this._depotEntryPinLocalService.deleteDepotEntryDepotEntryPins(depotEntry.getDepotEntryId());
        return depotEntry;
    }

    @Override
    public DepotEntry deleteDepotEntry(long depotEntryId) throws PortalException {
        return this.deleteDepotEntry(this.depotEntryPersistence.fetchByPrimaryKey(depotEntryId));
    }

    public DepotEntry fetchGroupDepotEntry(long groupId) {
        return this.depotEntryPersistence.fetchByGroupId(groupId);
    }

    public List<DepotEntry> getDepotEntries(long companyId, int type) {
        return this.depotEntryPersistence.findByC_T(companyId, type);
    }

    public int getDepotEntriesCount(long companyId, int type) {
        return this.depotEntryPersistence.countByC_T(companyId, type);
    }

    public List<Long> getDepotEntryGroupIds(long companyId, int type) {
        return (List)this.dslQuery((DSLQuery)DSLQueryFactoryUtil.selectDistinct((Expression[])new Expression[]{DepotEntryTable.INSTANCE.groupId}).from((Table)DepotEntryTable.INSTANCE).where(DepotEntryTable.INSTANCE.companyId.eq((Object)companyId).and(() -> {
            if (type != -1) {
                return DepotEntryTable.INSTANCE.type.eq((Object)type);
            }
            return null;
        }).and((Expression)DepotEntryTable.INSTANCE.groupId.isNotNull())));
    }

    public List<Long> getDepotEntryGroupIds(long companyId, long userId, int type) {
        return this.getDepotEntryGroupIds(companyId, userId, type, false);
    }

    public List<Long> getDepotEntryGroupIds(long companyId, long userId, int type, boolean userGroupsOnly) {
        if (userGroupsOnly) {
            return (List)this.dslQuery((DSLQuery)DSLQueryFactoryUtil.selectDistinct((Expression[])new Expression[]{DepotEntryTable.INSTANCE.groupId}).from((Table)DepotEntryTable.INSTANCE).innerJoinON((Table)Groups_UserGroupsTable.INSTANCE, Groups_UserGroupsTable.INSTANCE.groupId.eq((Expression)DepotEntryTable.INSTANCE.groupId)).innerJoinON((Table)Users_UserGroupsTable.INSTANCE, Users_UserGroupsTable.INSTANCE.userGroupId.eq((Expression)Groups_UserGroupsTable.INSTANCE.userGroupId).and((Expression)Users_UserGroupsTable.INSTANCE.userId.eq((Object)userId))).where(DepotEntryTable.INSTANCE.companyId.eq((Object)companyId).and(() -> {
                if (type != -1) {
                    return DepotEntryTable.INSTANCE.type.eq((Object)type);
                }
                return null;
            })));
        }
        return (List)this.dslQuery((DSLQuery)DSLQueryFactoryUtil.selectDistinct((Expression[])new Expression[]{DepotEntryTable.INSTANCE.groupId}).from((Table)DepotEntryTable.INSTANCE).leftJoinOn((Table)Users_GroupsTable.INSTANCE, Users_GroupsTable.INSTANCE.groupId.eq((Expression)DepotEntryTable.INSTANCE.groupId).and((Expression)Users_GroupsTable.INSTANCE.userId.eq((Object)userId))).leftJoinOn((Table)Groups_UserGroupsTable.INSTANCE, Groups_UserGroupsTable.INSTANCE.groupId.eq((Expression)DepotEntryTable.INSTANCE.groupId)).leftJoinOn((Table)Users_UserGroupsTable.INSTANCE, Users_UserGroupsTable.INSTANCE.userGroupId.eq((Expression)Groups_UserGroupsTable.INSTANCE.userGroupId).and((Expression)Users_UserGroupsTable.INSTANCE.userId.eq((Object)userId))).where(DepotEntryTable.INSTANCE.companyId.eq((Object)companyId).and(() -> {
            if (type != -1) {
                return DepotEntryTable.INSTANCE.type.eq((Object)type);
            }
            return null;
        }).and((Expression)Predicate.withParentheses((Predicate)Users_GroupsTable.INSTANCE.userId.isNotNull().or((Expression)Users_UserGroupsTable.INSTANCE.userId.isNotNull())))));
    }

    @Deprecated
    public List<DepotEntry> getDepotEntryGroupRelsByUuidAndCompanyId(String uuid, long companyId) {
        return this.depotEntryPersistence.findByUuid_C(uuid, companyId);
    }

    public List<DepotEntry> getGroupConnectedDepotEntries(long groupId, boolean ddmStructuresAvailable, int start, int end) throws PortalException {
        return TransformUtil.transform((Collection)this._depotEntryGroupRelPersistence.findByDDMSA_TGI(ddmStructuresAvailable, groupId, start, end), depotEntryGroupRel -> this.depotEntryLocalService.getDepotEntry(depotEntryGroupRel.getDepotEntryId()));
    }

    public List<DepotEntry> getGroupConnectedDepotEntries(long groupId, int type, int start, int end) throws PortalException {
        return TransformUtil.transform(this._getDepotEntryGroupRels(groupId, type, start, end), depotEntryGroupRel -> this.depotEntryLocalService.getDepotEntry(depotEntryGroupRel.getDepotEntryId()));
    }

    public int getGroupConnectedDepotEntriesCount(long groupId, int type) {
        if (type == -1) {
            return this._depotEntryGroupRelPersistence.countByToGroupId(groupId);
        }
        return this._depotEntryGroupRelPersistence.countByTGI_T(groupId, type);
    }

    public DepotEntry getGroupDepotEntry(long groupId) throws PortalException {
        return this.depotEntryPersistence.findByGroupId(groupId);
    }

    public DepotEntry updateDepotEntry(long depotEntryId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, Map<String, Boolean> depotAppCustomizationMap, UnicodeProperties typeSettingsUnicodeProperties, ServiceContext serviceContext) throws PortalException {
        DepotEntry depotEntry = this.getDepotEntry(depotEntryId);
        depotEntry.setModifiedDate(serviceContext.getModifiedDate());
        depotEntry = (DepotEntry)this.depotEntryPersistence.update((BaseModel)depotEntry);
        for (Map.Entry<String, Boolean> entry : depotAppCustomizationMap.entrySet()) {
            this._depotAppCustomizationLocalService.updateDepotAppCustomization(depotEntryId, entry.getValue().booleanValue(), entry.getKey());
        }
        this._validateTypeSettingsProperties(depotEntry, typeSettingsUnicodeProperties);
        for (String name : nameMap.values()) {
            this._validateName(name);
        }
        Group group = this._groupLocalService.getGroup(depotEntry.getGroupId());
        UnicodeProperties currentTypeSettingsUnicodeProperties = group.getTypeSettingsProperties();
        boolean inheritLocales = GetterUtil.getBoolean((String)currentTypeSettingsUnicodeProperties.getProperty("inheritLocales"), (boolean)true);
        inheritLocales = GetterUtil.getBoolean((String)typeSettingsUnicodeProperties.getProperty("inheritLocales"), (boolean)inheritLocales);
        if (inheritLocales) {
            typeSettingsUnicodeProperties.setProperty("locales", StringUtil.merge((Object[])LocaleUtil.toLanguageIds((Collection)this._language.getAvailableLocales())));
        }
        currentTypeSettingsUnicodeProperties.putAll((Map)typeSettingsUnicodeProperties);
        Locale locale = LocaleUtil.fromLanguageId((String)currentTypeSettingsUnicodeProperties.getProperty("languageId"));
        String defaultName = this._getDefaultName(nameMap, locale);
        if (defaultName != null) {
            nameMap.put(locale, defaultName);
        }
        group = this._groupLocalService.updateGroup(depotEntry.getGroupId(), group.getParentGroupId(), nameMap, descriptionMap, group.getType(), null, group.isManualMembership(), group.getMembershipRestriction(), group.getFriendlyURL(), group.isInheritContent(), group.isActive(), serviceContext);
        this._groupLocalService.updateGroup(group.getGroupId(), currentTypeSettingsUnicodeProperties.toString());
        return depotEntry;
    }

    private String _getDefaultName(Map<Locale, String> nameMap, Locale defaultLocale) {
        if (Validator.isNotNull((String)nameMap.get(defaultLocale))) {
            return null;
        }
        return this._language.get(defaultLocale, "unnamed-asset-library");
    }

    private List<DepotEntryGroupRel> _getDepotEntryGroupRels(long groupId, int type, int start, int end) {
        if (type == -1) {
            return this._depotEntryGroupRelPersistence.findByToGroupId(groupId, start, end);
        }
        return this._depotEntryGroupRelPersistence.findByTGI_T(groupId, type, start, end);
    }

    private boolean _isStaged(DepotEntry depotEntry) throws PortalException {
        if (depotEntry == null) {
            return false;
        }
        Group group = this._groupLocalService.fetchGroup(depotEntry.getGroupId());
        if (group == null) {
            return false;
        }
        return group.isStaged();
    }

    private void _validateName(String name) throws PortalException {
        int groupKeyMaxLength = ModelHintsUtil.getMaxLength((String)Group.class.getName(), (String)"name");
        if (Validator.isNotNull((String)name) && (Validator.isNumber((String)name) || name.contains("*") || name.contains(_ORGANIZATION_NAME_SUFFIX) || name.length() > groupKeyMaxLength)) {
            throw new GroupKeyException();
        }
    }

    private void _validateNameMap(Map<Locale, String> nameMap, Locale defaultLocale) throws DepotEntryNameException {
        if (MapUtil.isEmpty(nameMap) || Validator.isNull((String)nameMap.get(defaultLocale))) {
            throw new DepotEntryNameException();
        }
    }

    private void _validateTypeSettingsProperties(DepotEntry depotEntry, UnicodeProperties typeSettingsUnicodeProperties) throws LocaleException {
        if (!typeSettingsUnicodeProperties.containsKey((Object)"inheritLocales")) {
            return;
        }
        if (typeSettingsUnicodeProperties.containsKey((Object)"locales") && Validator.isNull((String)typeSettingsUnicodeProperties.getProperty("locales"))) {
            throw new LocaleException(4, "Must have at least one valid locale for asset library " + depotEntry.getGroupId());
        }
        boolean inheritLocales = GetterUtil.getBoolean((String)typeSettingsUnicodeProperties.getProperty("inheritLocales"));
        if (!inheritLocales && !typeSettingsUnicodeProperties.containsKey((Object)"locales")) {
            throw new LocaleException(4, "Must have at least one valid locale for asset library " + depotEntry.getGroupId());
        }
    }
}

