/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.depot.service.impl;

import com.liferay.depot.model.DepotEntry;
import com.liferay.depot.model.DepotEntryGroupRel;
import com.liferay.depot.service.base.DepotEntryGroupRelLocalServiceBaseImpl;
import com.liferay.depot.service.persistence.DepotEntryPersistence;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import com.liferay.portal.kernel.service.LayoutSetPrototypeLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.depot.model.DepotEntryGroupRel"}, service={AopService.class})
public class DepotEntryGroupRelLocalServiceImpl
extends DepotEntryGroupRelLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(DepotEntryGroupRelLocalServiceImpl.class);
    @Reference
    private DepotEntryPersistence _depotEntryPersistence;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private LayoutSetLocalService _layoutSetLocalService;
    @Reference
    private LayoutSetPrototypeLocalService _layoutSetPrototypeLocalService;

    public DepotEntryGroupRel addDepotEntryGroupRel(boolean ddmStructuresAvailable, long depotEntryId, long toGroupId, boolean searchable) throws PortalException {
        DepotEntryGroupRel depotEntryGroupRel = this.depotEntryGroupRelPersistence.fetchByD_TGI(depotEntryId, toGroupId);
        if (depotEntryGroupRel != null) {
            return depotEntryGroupRel;
        }
        Group toGroup = this._groupLocalService.getGroup(toGroupId);
        if (toGroup.isLayoutSetPrototype()) {
            this._connectLayoutSetPrototypeGroups(depotEntryId, toGroup);
        }
        depotEntryGroupRel = this.depotEntryGroupRelPersistence.create(this.counterLocalService.increment());
        depotEntryGroupRel.setGroupId(toGroupId);
        depotEntryGroupRel.setDdmStructuresAvailable(ddmStructuresAvailable);
        depotEntryGroupRel.setDepotEntryId(depotEntryId);
        depotEntryGroupRel.setSearchable(searchable);
        depotEntryGroupRel.setToGroupId(toGroupId);
        DepotEntry depotEntry = this._depotEntryPersistence.findByPrimaryKey(depotEntryId);
        depotEntryGroupRel.setType(depotEntry.getType());
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext != null) {
            depotEntryGroupRel.setUuid(serviceContext.getUuid());
        }
        return (DepotEntryGroupRel)this.depotEntryGroupRelPersistence.update((BaseModel)depotEntryGroupRel);
    }

    public DepotEntryGroupRel addDepotEntryGroupRel(long depotEntryId, long toGroupId) throws PortalException {
        return this.addDepotEntryGroupRel(depotEntryId, toGroupId, true);
    }

    public DepotEntryGroupRel addDepotEntryGroupRel(long depotEntryId, long toGroupId, boolean searchable) throws PortalException {
        return this.addDepotEntryGroupRel(false, depotEntryId, toGroupId, searchable);
    }

    @Override
    @SystemEvent(type=1)
    public DepotEntryGroupRel deleteDepotEntryGroupRel(DepotEntryGroupRel depotEntryGroupRel) throws PortalException {
        Group toGroup = this._groupLocalService.getGroup(depotEntryGroupRel.getToGroupId());
        if (toGroup.isLayoutSetPrototype()) {
            this._disconnectLayoutSetPrototypeGroups(depotEntryGroupRel.getDepotEntryId(), toGroup);
        }
        return super.deleteDepotEntryGroupRel(depotEntryGroupRel);
    }

    @Override
    public DepotEntryGroupRel deleteDepotEntryGroupRel(long depotEntryGroupRelId) throws PortalException {
        return this.depotEntryGroupRelLocalService.deleteDepotEntryGroupRel(this.getDepotEntryGroupRel(depotEntryGroupRelId));
    }

    public void deleteToGroupDepotEntryGroupRels(long toGroupId) {
        this.depotEntryGroupRelPersistence.removeByToGroupId(toGroupId);
    }

    public DepotEntryGroupRel fetchDepotEntryGroupRelByDepotEntryIdToGroupId(long depotEntryId, long toGroupId) {
        return this.depotEntryGroupRelPersistence.fetchByD_TGI(depotEntryId, toGroupId);
    }

    public DepotEntryGroupRel getDepotEntryGroupRelByDepotEntryIdToGroupId(long depotEntryId, long toGroupId) throws PortalException {
        return this.depotEntryGroupRelPersistence.findByD_TGI(depotEntryId, toGroupId);
    }

    public List<DepotEntryGroupRel> getDepotEntryGroupRels(DepotEntry depotEntry) {
        return this.depotEntryGroupRelPersistence.findByDepotEntryId(depotEntry.getDepotEntryId());
    }

    public List<DepotEntryGroupRel> getDepotEntryGroupRels(DepotEntry depotEntry, int start, int end) {
        return this.depotEntryGroupRelPersistence.findByDepotEntryId(depotEntry.getDepotEntryId(), start, end);
    }

    public List<DepotEntryGroupRel> getDepotEntryGroupRels(long groupId, int type, int start, int end) {
        if (type == -1) {
            return this.depotEntryGroupRelPersistence.findByToGroupId(groupId);
        }
        return this.depotEntryGroupRelPersistence.findByTGI_T(groupId, type, start, end);
    }

    public int getDepotEntryGroupRelsCount(DepotEntry depotEntry) {
        return this.depotEntryGroupRelPersistence.countByDepotEntryId(depotEntry.getDepotEntryId());
    }

    public int getDepotEntryGroupRelsCount(long groupId, int type) {
        if (type == -1) {
            return this.depotEntryGroupRelPersistence.countByToGroupId(groupId);
        }
        return this.depotEntryGroupRelPersistence.countByTGI_T(groupId, type);
    }

    public List<DepotEntryGroupRel> getSearchableDepotEntryGroupRels(long groupId, int start, int end) {
        return this.depotEntryGroupRelPersistence.findByS_TGI(true, groupId, start, end);
    }

    public int getSearchableDepotEntryGroupRelsCount(long groupId) {
        return this.depotEntryGroupRelPersistence.countByS_TGI(true, groupId);
    }

    public DepotEntryGroupRel updateDDMStructuresAvailable(long depotEntryGroupRelId, boolean ddmStructuresAvailable) throws PortalException {
        DepotEntryGroupRel depotEntryGroupRel = this.getDepotEntryGroupRel(depotEntryGroupRelId);
        depotEntryGroupRel.setDdmStructuresAvailable(ddmStructuresAvailable);
        return (DepotEntryGroupRel)this.depotEntryGroupRelPersistence.update((BaseModel)depotEntryGroupRel);
    }

    public DepotEntryGroupRel updateSearchable(long depotEntryGroupRelId, boolean searchable) throws PortalException {
        DepotEntryGroupRel depotEntryGroupRel = this.getDepotEntryGroupRel(depotEntryGroupRelId);
        depotEntryGroupRel.setSearchable(searchable);
        return (DepotEntryGroupRel)this.depotEntryGroupRelPersistence.update((BaseModel)depotEntryGroupRel);
    }

    private void _connectLayoutSetPrototypeGroups(long depotEntryId, Group toGroup) throws PortalException {
        LayoutSetPrototype layoutSetPrototype = this._layoutSetPrototypeLocalService.getLayoutSetPrototype(toGroup.getClassPK());
        UnicodeProperties settingsUnicodeProperties = layoutSetPrototype.getSettingsProperties();
        boolean readyForPropagation = GetterUtil.getBoolean((String)settingsUnicodeProperties.getProperty("readyForPropagation"));
        if (!readyForPropagation) {
            return;
        }
        List layoutSets = this._layoutSetLocalService.getLayoutSetsByLayoutSetPrototypeUuid(layoutSetPrototype.getUuid());
        for (LayoutSet layoutSet : layoutSets) {
            this.addDepotEntryGroupRel(depotEntryId, layoutSet.getGroupId());
        }
    }

    private void _disconnectLayoutSetPrototypeGroups(long depotEntryId, Group group) throws PortalException {
        LayoutSetPrototype layoutSetPrototype = this._layoutSetPrototypeLocalService.getLayoutSetPrototype(group.getClassPK());
        UnicodeProperties settingsUnicodeProperties = layoutSetPrototype.getSettingsProperties();
        boolean readyForPropagation = GetterUtil.getBoolean((String)settingsUnicodeProperties.getProperty("readyForPropagation"));
        if (!readyForPropagation) {
            return;
        }
        List layoutSets = this._layoutSetLocalService.getLayoutSetsByLayoutSetPrototypeUuid(layoutSetPrototype.getUuid());
        for (LayoutSet layoutSet : layoutSets) {
            DepotEntryGroupRel depotEntryGroupRel = this.fetchDepotEntryGroupRelByDepotEntryIdToGroupId(depotEntryId, layoutSet.getGroupId());
            if (depotEntryGroupRel == null) continue;
            if (depotEntryGroupRel.isDdmStructuresAvailable()) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to disconnect " + depotEntryGroupRel.getToGroupId()));
                continue;
            }
            this.depotEntryGroupRelLocalService.deleteDepotEntryGroupRel(depotEntryGroupRel);
        }
    }
}

