/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.depot.internal.security.permission.wrapper;

import com.liferay.depot.model.DepotEntry;
import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.wrapper.PermissionCheckerWrapper;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.UserGroupRoleLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class DepotPermissionCheckerWrapper
extends PermissionCheckerWrapper {
    private static final Log _log = LogFactoryUtil.getLog(DepotPermissionCheckerWrapper.class);
    private static final Set<String> _supportedActionIds = new HashSet<String>(Arrays.asList("ASSIGN_MEMBERS", "ASSIGN_USER_ROLES", "DELETE", "PUBLISH_STAGING", "UPDATE", "VIEW", "VIEW_MEMBERS", "VIEW_SITE_ADMINISTRATION", "VIEW_STAGING"));
    private final ModelResourcePermission<DepotEntry> _depotEntryModelResourcePermission;
    private final GroupLocalService _groupLocalService;
    private final RoleLocalService _roleLocalService;
    private final UserGroupRoleLocalService _userGroupRoleLocalService;

    public DepotPermissionCheckerWrapper(PermissionChecker permissionChecker, ModelResourcePermission<DepotEntry> depotEntryModelResourcePermission, GroupLocalService groupLocalService, RoleLocalService roleLocalService, UserGroupRoleLocalService userGroupRoleLocalService) {
        super(permissionChecker);
        this._depotEntryModelResourcePermission = depotEntryModelResourcePermission;
        this._groupLocalService = groupLocalService;
        this._roleLocalService = roleLocalService;
        this._userGroupRoleLocalService = userGroupRoleLocalService;
    }

    public boolean hasPermission(Group group, String name, long primKey, String actionId) {
        if (this._isDepotGroupOwner(group)) {
            return true;
        }
        Boolean hasPermission = this._hasPermission(name, primKey, actionId);
        if (hasPermission != null) {
            return hasPermission;
        }
        return this.permissionChecker.hasPermission(group, name, primKey, actionId);
    }

    public boolean hasPermission(Group group, String name, String primKey, String actionId) {
        if (this._isDepotGroupOwner(group)) {
            return true;
        }
        Boolean hasPermission = this._hasPermission(name, GetterUtil.getLong((String)primKey), actionId);
        if (hasPermission != null) {
            return hasPermission;
        }
        return this.permissionChecker.hasPermission(group, name, primKey, actionId);
    }

    public boolean hasPermission(long groupId, String name, long primKey, String actionId) {
        if (this._isDepotGroupOwner(this._groupLocalService.fetchGroup(groupId))) {
            return true;
        }
        Boolean hasPermission = this._hasPermission(name, primKey, actionId);
        if (hasPermission != null) {
            return hasPermission;
        }
        return this.permissionChecker.hasPermission(groupId, name, primKey, actionId);
    }

    public boolean hasPermission(long groupId, String name, String primKey, String actionId) {
        if (this._isDepotGroupOwner(this._groupLocalService.fetchGroup(groupId))) {
            return true;
        }
        Boolean hasPermission = this._hasPermission(name, GetterUtil.getLong((String)primKey), actionId);
        if (hasPermission != null) {
            return hasPermission;
        }
        return this.permissionChecker.hasPermission(groupId, name, primKey, actionId);
    }

    public boolean isContentReviewer(long companyId, long groupId) {
        try {
            if (!this.isSignedIn()) {
                return false;
            }
            if (this.permissionChecker.isContentReviewer(companyId, groupId) || this.isGroupAdmin(groupId)) {
                return true;
            }
            return this._isOrAddToPermissionCache(this._groupLocalService.fetchGroup(groupId), "Asset Library Content Reviewer", (UnsafeFunction<Group, Boolean, Exception>)((UnsafeFunction)this::_isContentReviewer));
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return false;
        }
    }

    public boolean isGroupAdmin(long groupId) {
        try {
            if (!this.isSignedIn()) {
                return false;
            }
            if (this.permissionChecker.isGroupAdmin(groupId)) {
                return true;
            }
            Group group = this._groupLocalService.fetchGroup(groupId);
            if (this._isCMSAdministrator(group)) {
                return true;
            }
            return this._isOrAddToPermissionCache(group, "Asset Library Administrator", (UnsafeFunction<Group, Boolean, Exception>)((UnsafeFunction)this::_isGroupAdmin));
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return false;
        }
    }

    public boolean isGroupMember(long groupId) {
        try {
            if (!this.isSignedIn()) {
                return false;
            }
            if (this.permissionChecker.isGroupMember(groupId)) {
                return true;
            }
            return this._isGroupMember(this._groupLocalService.fetchGroup(groupId));
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return false;
        }
    }

    public boolean isGroupOwner(long groupId) {
        try {
            if (!this.isSignedIn()) {
                return false;
            }
            if (this.permissionChecker.isGroupOwner(groupId)) {
                return true;
            }
            return this._isOrAddToPermissionCache(this._groupLocalService.fetchGroup(groupId), "Asset Library Owner", (UnsafeFunction<Group, Boolean, Exception>)((UnsafeFunction)this::_isGroupOwner));
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return false;
        }
    }

    private Boolean _hasPermission(String name, long primKey, String actionId) {
        Group group;
        if (StringUtil.equals((String)name, (String)Group.class.getName()) && (group = this._groupLocalService.fetchGroup(primKey)) != null && group.isDepot()) {
            try {
                if (!_supportedActionIds.contains(actionId)) {
                    return false;
                }
                if (this._isCMSAdministrator(group) || this._isGroupAdmin(group)) {
                    return true;
                }
                return this._depotEntryModelResourcePermission.contains((PermissionChecker)this, group.getClassPK(), actionId);
            }
            catch (PortalException portalException) {
                _log.error((Throwable)portalException);
                return false;
            }
        }
        return null;
    }

    private boolean _hasRole(long companyId, long[] roleIds, String roleName) throws Exception {
        Role role = this._roleLocalService.getRole(companyId, roleName);
        return Arrays.binarySearch(roleIds, role.getRoleId()) >= 0;
    }

    private boolean _isCMSAdministrator(Group group) throws PortalException {
        if (group == null || !group.isDepot()) {
            return false;
        }
        long depotEntryType = GetterUtil.getInteger((String)group.getTypeSettingsProperty("depotEntryType"), (int)0);
        if (depotEntryType != 1L) {
            return false;
        }
        Boolean value = PermissionCacheUtil.getUserPrimaryKeyRole((long)this.getUserId(), (long)group.getCompanyId(), (String)"CMS Administrator");
        if (value == null) {
            value = this._roleLocalService.hasUserRole(this.getUserId(), group.getCompanyId(), "CMS Administrator", true);
            PermissionCacheUtil.putUserPrimaryKeyRole((long)this.getUserId(), (long)group.getCompanyId(), (String)"CMS Administrator", (Boolean)value);
        }
        return value;
    }

    private boolean _isContentReviewer(Group group) throws PortalException {
        if (group == null || !group.isDepot()) {
            return false;
        }
        Group liveGroup = StagingUtil.getLiveGroup((Group)group);
        return this._userGroupRoleLocalService.hasUserGroupRole(this.getUserId(), liveGroup.getGroupId(), "Asset Library Content Reviewer", true);
    }

    private boolean _isDepotGroupOwner(Group group) {
        return group != null && group.isDepot() && this.isGroupOwner(group.getGroupId());
    }

    private boolean _isGroupAdmin(Group group) throws PortalException {
        if (group == null || !group.isDepot()) {
            return false;
        }
        Group liveGroup = StagingUtil.getLiveGroup((Group)group);
        if (this._userGroupRoleLocalService.hasUserGroupRole(this.getUserId(), liveGroup.getGroupId(), "Asset Library Administrator", true) || this._userGroupRoleLocalService.hasUserGroupRole(this.getUserId(), liveGroup.getGroupId(), "Asset Library Owner", true)) {
            return true;
        }
        Group parentGroup = liveGroup;
        while (!parentGroup.isRoot()) {
            if (!this.permissionChecker.hasPermission(parentGroup = parentGroup.getParentGroup(), Group.class.getName(), String.valueOf(parentGroup.getGroupId()), "MANAGE_SUBGROUPS")) continue;
            return true;
        }
        return false;
    }

    private boolean _isGroupMember(Group group) throws Exception {
        if (group == null || !group.isDepot()) {
            return false;
        }
        Group liveGroup = StagingUtil.getLiveGroup((Group)group);
        long[] roleIds = this.getRoleIds(this.getUserId(), liveGroup.getGroupId());
        return this._hasRole(liveGroup.getCompanyId(), roleIds, "Asset Library Connected Site Member") || this._hasRole(liveGroup.getCompanyId(), roleIds, "Asset Library Member");
    }

    private boolean _isGroupOwner(Group group) throws PortalException {
        if (group == null || !group.isDepot()) {
            return false;
        }
        Group liveGroup = StagingUtil.getLiveGroup((Group)group);
        return this._userGroupRoleLocalService.hasUserGroupRole(this.getUserId(), liveGroup.getGroupId(), "Asset Library Owner", true);
    }

    private boolean _isOrAddToPermissionCache(Group group, String roleName, UnsafeFunction<Group, Boolean, Exception> unsafeFunction) throws Exception {
        if (group == null) {
            return false;
        }
        Boolean value = PermissionCacheUtil.getUserPrimaryKeyRole((long)this.getUserId(), (long)group.getGroupId(), (String)roleName);
        if (value != null) {
            return value;
        }
        value = (Boolean)unsafeFunction.apply((Object)group);
        PermissionCacheUtil.putUserPrimaryKeyRole((long)this.getUserId(), (long)group.getGroupId(), (String)roleName, (Boolean)value);
        return value;
    }
}

