/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.depot.internal.search.spi.model.permission.contributor;

import com.liferay.depot.service.DepotEntryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.search.spi.model.permission.contributor.SearchPermissionFilterContributor;
import java.util.Iterator;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SearchPermissionFilterContributor.class})
public class DepotEntrySearchPermissionFilterContributor
implements SearchPermissionFilterContributor {
    private static final Log _log = LogFactoryUtil.getLog(DepotEntrySearchPermissionFilterContributor.class);
    @Reference
    private DepotEntryLocalService _depotEntryLocalService;
    @Reference
    private RoleLocalService _roleLocalService;

    public void contribute(BooleanFilter booleanFilter, long companyId, long[] groupIds, long userId, PermissionChecker permissionChecker, String className) {
        try {
            this._contribute(booleanFilter, companyId, userId, permissionChecker);
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
        }
    }

    private void _contribute(BooleanFilter booleanFilter, long companyId, long userId, PermissionChecker permissionChecker) throws PortalException {
        if (userId == 0L) {
            return;
        }
        Role role = this._roleLocalService.fetchRole(companyId, "Asset Library Member");
        if (role == null) {
            return;
        }
        Iterator iterator = this._depotEntryLocalService.getDepotEntryGroupIds(permissionChecker.getCompanyId(), userId, -1, true).iterator();
        while (iterator.hasNext()) {
            long groupId = (Long)iterator.next();
            TermsFilter termsFilter = new TermsFilter("groupRoleId");
            termsFilter.addValues(new String[]{groupId + "-" + role.getRoleId()});
            booleanFilter.add((Filter)termsFilter, BooleanClauseOccur.SHOULD);
        }
    }
}

