/**
 * SPDX-FileCopyrightText: (c) 2025 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.depot.service.base;

import com.liferay.depot.model.DepotEntryPin;
import com.liferay.depot.service.DepotEntryPinLocalService;
import com.liferay.depot.service.persistence.DepotEntryPinPersistence;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.change.tracking.CTService;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.change.tracking.CTPersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;

import java.io.Serializable;

import java.sql.Connection;

import java.util.List;

import javax.sql.DataSource;

import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

/**
 * Provides the base implementation for the depot entry pin local service.
 *
 * <p>
 * This implementation exists only as a container for the default service methods generated by ServiceBuilder. All custom service methods should be put in {@link com.liferay.depot.service.impl.DepotEntryPinLocalServiceImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see com.liferay.depot.service.impl.DepotEntryPinLocalServiceImpl
 * @generated
 */
public abstract class DepotEntryPinLocalServiceBaseImpl
	extends BaseLocalServiceImpl
	implements AopService, DepotEntryPinLocalService, IdentifiableOSGiService {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. Use <code>DepotEntryPinLocalService</code> via injection or a <code>org.osgi.util.tracker.ServiceTracker</code> or use <code>com.liferay.depot.service.DepotEntryPinLocalServiceUtil</code>.
	 */

	/**
	 * Adds the depot entry pin to the database. Also notifies the appropriate model listeners.
	 *
	 * <p>
	 * <strong>Important:</strong> Inspect DepotEntryPinLocalServiceImpl for overloaded versions of the method. If provided, use these entry points to the API, as the implementation logic may require the additional parameters defined there.
	 * </p>
	 *
	 * @param depotEntryPin the depot entry pin
	 * @return the depot entry pin that was added
	 */
	@Indexable(type = IndexableType.REINDEX)
	@Override
	public DepotEntryPin addDepotEntryPin(DepotEntryPin depotEntryPin) {
		depotEntryPin.setNew(true);

		return depotEntryPinPersistence.update(depotEntryPin);
	}

	/**
	 * Creates a new depot entry pin with the primary key. Does not add the depot entry pin to the database.
	 *
	 * @param depotEntryPinId the primary key for the new depot entry pin
	 * @return the new depot entry pin
	 */
	@Override
	@Transactional(enabled = false)
	public DepotEntryPin createDepotEntryPin(long depotEntryPinId) {
		return depotEntryPinPersistence.create(depotEntryPinId);
	}

	/**
	 * Deletes the depot entry pin with the primary key from the database. Also notifies the appropriate model listeners.
	 *
	 * <p>
	 * <strong>Important:</strong> Inspect DepotEntryPinLocalServiceImpl for overloaded versions of the method. If provided, use these entry points to the API, as the implementation logic may require the additional parameters defined there.
	 * </p>
	 *
	 * @param depotEntryPinId the primary key of the depot entry pin
	 * @return the depot entry pin that was removed
	 * @throws PortalException if a depot entry pin with the primary key could not be found
	 */
	@Indexable(type = IndexableType.DELETE)
	@Override
	public DepotEntryPin deleteDepotEntryPin(long depotEntryPinId)
		throws PortalException {

		return depotEntryPinPersistence.remove(depotEntryPinId);
	}

	/**
	 * Deletes the depot entry pin from the database. Also notifies the appropriate model listeners.
	 *
	 * <p>
	 * <strong>Important:</strong> Inspect DepotEntryPinLocalServiceImpl for overloaded versions of the method. If provided, use these entry points to the API, as the implementation logic may require the additional parameters defined there.
	 * </p>
	 *
	 * @param depotEntryPin the depot entry pin
	 * @return the depot entry pin that was removed
	 */
	@Indexable(type = IndexableType.DELETE)
	@Override
	public DepotEntryPin deleteDepotEntryPin(DepotEntryPin depotEntryPin) {
		return depotEntryPinPersistence.remove(depotEntryPin);
	}

	@Override
	public <T> T dslQuery(DSLQuery dslQuery) {
		return depotEntryPinPersistence.dslQuery(dslQuery);
	}

	@Override
	public int dslQueryCount(DSLQuery dslQuery) {
		Long count = dslQuery(dslQuery);

		return count.intValue();
	}

	@Override
	public DynamicQuery dynamicQuery() {
		Class<?> clazz = getClass();

		return DynamicQueryFactoryUtil.forClass(
			DepotEntryPin.class, clazz.getClassLoader());
	}

	/**
	 * Performs a dynamic query on the database and returns the matching rows.
	 *
	 * @param dynamicQuery the dynamic query
	 * @return the matching rows
	 */
	@Override
	public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
		return depotEntryPinPersistence.findWithDynamicQuery(dynamicQuery);
	}

	/**
	 * Performs a dynamic query on the database and returns a range of the matching rows.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>com.liferay.depot.model.impl.DepotEntryPinModelImpl</code>.
	 * </p>
	 *
	 * @param dynamicQuery the dynamic query
	 * @param start the lower bound of the range of model instances
	 * @param end the upper bound of the range of model instances (not inclusive)
	 * @return the range of matching rows
	 */
	@Override
	public <T> List<T> dynamicQuery(
		DynamicQuery dynamicQuery, int start, int end) {

		return depotEntryPinPersistence.findWithDynamicQuery(
			dynamicQuery, start, end);
	}

	/**
	 * Performs a dynamic query on the database and returns an ordered range of the matching rows.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>com.liferay.depot.model.impl.DepotEntryPinModelImpl</code>.
	 * </p>
	 *
	 * @param dynamicQuery the dynamic query
	 * @param start the lower bound of the range of model instances
	 * @param end the upper bound of the range of model instances (not inclusive)
	 * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	 * @return the ordered range of matching rows
	 */
	@Override
	public <T> List<T> dynamicQuery(
		DynamicQuery dynamicQuery, int start, int end,
		OrderByComparator<T> orderByComparator) {

		return depotEntryPinPersistence.findWithDynamicQuery(
			dynamicQuery, start, end, orderByComparator);
	}

	/**
	 * Returns the number of rows matching the dynamic query.
	 *
	 * @param dynamicQuery the dynamic query
	 * @return the number of rows matching the dynamic query
	 */
	@Override
	public long dynamicQueryCount(DynamicQuery dynamicQuery) {
		return depotEntryPinPersistence.countWithDynamicQuery(dynamicQuery);
	}

	/**
	 * Returns the number of rows matching the dynamic query.
	 *
	 * @param dynamicQuery the dynamic query
	 * @param projection the projection to apply to the query
	 * @return the number of rows matching the dynamic query
	 */
	@Override
	public long dynamicQueryCount(
		DynamicQuery dynamicQuery, Projection projection) {

		return depotEntryPinPersistence.countWithDynamicQuery(
			dynamicQuery, projection);
	}

	@Override
	public DepotEntryPin fetchDepotEntryPin(long depotEntryPinId) {
		return depotEntryPinPersistence.fetchByPrimaryKey(depotEntryPinId);
	}

	/**
	 * Returns the depot entry pin matching the UUID and group.
	 *
	 * @param uuid the depot entry pin's UUID
	 * @param groupId the primary key of the group
	 * @return the matching depot entry pin, or <code>null</code> if a matching depot entry pin could not be found
	 */
	@Override
	public DepotEntryPin fetchDepotEntryPinByUuidAndGroupId(
		String uuid, long groupId) {

		return depotEntryPinPersistence.fetchByUUID_G(uuid, groupId);
	}

	/**
	 * Returns the depot entry pin with the primary key.
	 *
	 * @param depotEntryPinId the primary key of the depot entry pin
	 * @return the depot entry pin
	 * @throws PortalException if a depot entry pin with the primary key could not be found
	 */
	@Override
	public DepotEntryPin getDepotEntryPin(long depotEntryPinId)
		throws PortalException {

		return depotEntryPinPersistence.findByPrimaryKey(depotEntryPinId);
	}

	@Override
	public ActionableDynamicQuery getActionableDynamicQuery() {
		ActionableDynamicQuery actionableDynamicQuery =
			new DefaultActionableDynamicQuery();

		actionableDynamicQuery.setBaseLocalService(depotEntryPinLocalService);
		actionableDynamicQuery.setClassLoader(getClassLoader());
		actionableDynamicQuery.setModelClass(DepotEntryPin.class);

		actionableDynamicQuery.setPrimaryKeyPropertyName("depotEntryPinId");

		return actionableDynamicQuery;
	}

	@Override
	public IndexableActionableDynamicQuery
		getIndexableActionableDynamicQuery() {

		IndexableActionableDynamicQuery indexableActionableDynamicQuery =
			new IndexableActionableDynamicQuery();

		indexableActionableDynamicQuery.setBaseLocalService(
			depotEntryPinLocalService);
		indexableActionableDynamicQuery.setClassLoader(getClassLoader());
		indexableActionableDynamicQuery.setModelClass(DepotEntryPin.class);

		indexableActionableDynamicQuery.setPrimaryKeyPropertyName(
			"depotEntryPinId");

		return indexableActionableDynamicQuery;
	}

	protected void initActionableDynamicQuery(
		ActionableDynamicQuery actionableDynamicQuery) {

		actionableDynamicQuery.setBaseLocalService(depotEntryPinLocalService);
		actionableDynamicQuery.setClassLoader(getClassLoader());
		actionableDynamicQuery.setModelClass(DepotEntryPin.class);

		actionableDynamicQuery.setPrimaryKeyPropertyName("depotEntryPinId");
	}

	/**
	 * @throws PortalException
	 */
	@Override
	public PersistedModel createPersistedModel(Serializable primaryKeyObj)
		throws PortalException {

		return depotEntryPinPersistence.create(
			((Long)primaryKeyObj).longValue());
	}

	/**
	 * @throws PortalException
	 */
	@Override
	public PersistedModel deletePersistedModel(PersistedModel persistedModel)
		throws PortalException {

		if (_log.isWarnEnabled()) {
			_log.warn(
				"Implement DepotEntryPinLocalServiceImpl#deleteDepotEntryPin(DepotEntryPin) to avoid orphaned data");
		}

		return depotEntryPinLocalService.deleteDepotEntryPin(
			(DepotEntryPin)persistedModel);
	}

	@Override
	public BasePersistence<DepotEntryPin> getBasePersistence() {
		return depotEntryPinPersistence;
	}

	/**
	 * @throws PortalException
	 */
	@Override
	public PersistedModel getPersistedModel(Serializable primaryKeyObj)
		throws PortalException {

		return depotEntryPinPersistence.findByPrimaryKey(primaryKeyObj);
	}

	/**
	 * Returns all the depot entry pins matching the UUID and company.
	 *
	 * @param uuid the UUID of the depot entry pins
	 * @param companyId the primary key of the company
	 * @return the matching depot entry pins, or an empty list if no matches were found
	 */
	@Override
	public List<DepotEntryPin> getDepotEntryPinsByUuidAndCompanyId(
		String uuid, long companyId) {

		return depotEntryPinPersistence.findByUuid_C(uuid, companyId);
	}

	/**
	 * Returns a range of depot entry pins matching the UUID and company.
	 *
	 * @param uuid the UUID of the depot entry pins
	 * @param companyId the primary key of the company
	 * @param start the lower bound of the range of depot entry pins
	 * @param end the upper bound of the range of depot entry pins (not inclusive)
	 * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	 * @return the range of matching depot entry pins, or an empty list if no matches were found
	 */
	@Override
	public List<DepotEntryPin> getDepotEntryPinsByUuidAndCompanyId(
		String uuid, long companyId, int start, int end,
		OrderByComparator<DepotEntryPin> orderByComparator) {

		return depotEntryPinPersistence.findByUuid_C(
			uuid, companyId, start, end, orderByComparator);
	}

	/**
	 * Returns the depot entry pin matching the UUID and group.
	 *
	 * @param uuid the depot entry pin's UUID
	 * @param groupId the primary key of the group
	 * @return the matching depot entry pin
	 * @throws PortalException if a matching depot entry pin could not be found
	 */
	@Override
	public DepotEntryPin getDepotEntryPinByUuidAndGroupId(
			String uuid, long groupId)
		throws PortalException {

		return depotEntryPinPersistence.findByUUID_G(uuid, groupId);
	}

	/**
	 * Returns a range of all the depot entry pins.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>com.liferay.depot.model.impl.DepotEntryPinModelImpl</code>.
	 * </p>
	 *
	 * @param start the lower bound of the range of depot entry pins
	 * @param end the upper bound of the range of depot entry pins (not inclusive)
	 * @return the range of depot entry pins
	 */
	@Override
	public List<DepotEntryPin> getDepotEntryPins(int start, int end) {
		return depotEntryPinPersistence.findAll(start, end);
	}

	/**
	 * Returns the number of depot entry pins.
	 *
	 * @return the number of depot entry pins
	 */
	@Override
	public int getDepotEntryPinsCount() {
		return depotEntryPinPersistence.countAll();
	}

	/**
	 * Updates the depot entry pin in the database or adds it if it does not yet exist. Also notifies the appropriate model listeners.
	 *
	 * <p>
	 * <strong>Important:</strong> Inspect DepotEntryPinLocalServiceImpl for overloaded versions of the method. If provided, use these entry points to the API, as the implementation logic may require the additional parameters defined there.
	 * </p>
	 *
	 * @param depotEntryPin the depot entry pin
	 * @return the depot entry pin that was updated
	 */
	@Indexable(type = IndexableType.REINDEX)
	@Override
	public DepotEntryPin updateDepotEntryPin(DepotEntryPin depotEntryPin) {
		return depotEntryPinPersistence.update(depotEntryPin);
	}

	@Deactivate
	protected void deactivate() {
	}

	@Override
	public Class<?>[] getAopInterfaces() {
		return new Class<?>[] {
			DepotEntryPinLocalService.class, IdentifiableOSGiService.class,
			CTService.class, PersistedModelLocalService.class
		};
	}

	@Override
	public void setAopProxy(Object aopProxy) {
		depotEntryPinLocalService = (DepotEntryPinLocalService)aopProxy;
	}

	/**
	 * Returns the OSGi service identifier.
	 *
	 * @return the OSGi service identifier
	 */
	@Override
	public String getOSGiServiceIdentifier() {
		return DepotEntryPinLocalService.class.getName();
	}

	@Override
	public CTPersistence<DepotEntryPin> getCTPersistence() {
		return depotEntryPinPersistence;
	}

	@Override
	public Class<DepotEntryPin> getModelClass() {
		return DepotEntryPin.class;
	}

	@Override
	public <R, E extends Throwable> R updateWithUnsafeFunction(
			UnsafeFunction<CTPersistence<DepotEntryPin>, R, E>
				updateUnsafeFunction)
		throws E {

		return updateUnsafeFunction.apply(depotEntryPinPersistence);
	}

	protected String getModelClassName() {
		return DepotEntryPin.class.getName();
	}

	/**
	 * Performs a SQL query.
	 *
	 * @param sql the sql query
	 */
	protected void runSQL(String sql) {
		DataSource dataSource = depotEntryPinPersistence.getDataSource();

		DB db = DBManagerUtil.getDB();

		Connection currentConnection = CurrentConnectionUtil.getConnection(
			dataSource);

		try {
			if (currentConnection != null) {
				db.runSQL(currentConnection, new String[] {sql});

				return;
			}

			try (Connection connection = dataSource.getConnection()) {
				db.runSQL(connection, new String[] {sql});
			}
		}
		catch (Exception exception) {
			throw new SystemException(exception);
		}
	}

	protected DepotEntryPinLocalService depotEntryPinLocalService;

	@Reference
	protected DepotEntryPinPersistence depotEntryPinPersistence;

	@Reference
	protected com.liferay.counter.kernel.service.CounterLocalService
		counterLocalService;

	private static final Log _log = LogFactoryUtil.getLog(
		DepotEntryPinLocalServiceBaseImpl.class);

}