/**
 * SPDX-FileCopyrightText: (c) 2025 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.depot.model.impl;

import com.liferay.depot.model.DepotEntryPin;
import com.liferay.depot.model.DepotEntryPinModel;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the DepotEntryPin service. Represents a row in the &quot;DepotEntryPin&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>DepotEntryPinModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link DepotEntryPinImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see DepotEntryPinImpl
 * @generated
 */
@JSON(strict = true)
public class DepotEntryPinModelImpl
	extends BaseModelImpl<DepotEntryPin> implements DepotEntryPinModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a depot entry pin model instance should use the <code>DepotEntryPin</code> interface instead.
	 */
	public static final String TABLE_NAME = "DepotEntryPin";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"ctCollectionId", Types.BIGINT},
		{"uuid_", Types.VARCHAR}, {"depotEntryPinId", Types.BIGINT},
		{"groupId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"depotEntryId", Types.BIGINT}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("ctCollectionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("depotEntryPinId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("depotEntryId", Types.BIGINT);
	}

	public static final String TABLE_SQL_CREATE =
		"create table DepotEntryPin (mvccVersion LONG default 0 not null,ctCollectionId LONG default 0 not null,uuid_ VARCHAR(75) null,depotEntryPinId LONG not null,groupId LONG,companyId LONG,userId LONG,depotEntryId LONG,primary key (depotEntryPinId, ctCollectionId))";

	public static final String TABLE_SQL_DROP = "drop table DepotEntryPin";

	public static final String ORDER_BY_JPQL =
		" ORDER BY depotEntryPin.depotEntryPinId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY DepotEntryPin.depotEntryPinId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long DEPOTENTRYID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long GROUPID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long USERID_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long DEPOTENTRYPINID_COLUMN_BITMASK = 32L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public DepotEntryPinModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _depotEntryPinId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setDepotEntryPinId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _depotEntryPinId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return DepotEntryPin.class;
	}

	@Override
	public String getModelClassName() {
		return DepotEntryPin.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<DepotEntryPin, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		for (Map.Entry<String, Function<DepotEntryPin, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<DepotEntryPin, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((DepotEntryPin)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<DepotEntryPin, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<DepotEntryPin, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(DepotEntryPin)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<DepotEntryPin, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<DepotEntryPin, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map<String, Function<DepotEntryPin, Object>>
			_attributeGetterFunctions;

		static {
			Map<String, Function<DepotEntryPin, Object>>
				attributeGetterFunctions =
					new LinkedHashMap
						<String, Function<DepotEntryPin, Object>>();

			attributeGetterFunctions.put(
				"mvccVersion", DepotEntryPin::getMvccVersion);
			attributeGetterFunctions.put(
				"ctCollectionId", DepotEntryPin::getCtCollectionId);
			attributeGetterFunctions.put("uuid", DepotEntryPin::getUuid);
			attributeGetterFunctions.put(
				"depotEntryPinId", DepotEntryPin::getDepotEntryPinId);
			attributeGetterFunctions.put("groupId", DepotEntryPin::getGroupId);
			attributeGetterFunctions.put(
				"companyId", DepotEntryPin::getCompanyId);
			attributeGetterFunctions.put("userId", DepotEntryPin::getUserId);
			attributeGetterFunctions.put(
				"depotEntryId", DepotEntryPin::getDepotEntryId);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map<String, BiConsumer<DepotEntryPin, Object>>
			_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<DepotEntryPin, ?>>
				attributeSetterBiConsumers =
					new LinkedHashMap<String, BiConsumer<DepotEntryPin, ?>>();

			attributeSetterBiConsumers.put(
				"mvccVersion",
				(BiConsumer<DepotEntryPin, Long>)DepotEntryPin::setMvccVersion);
			attributeSetterBiConsumers.put(
				"ctCollectionId",
				(BiConsumer<DepotEntryPin, Long>)
					DepotEntryPin::setCtCollectionId);
			attributeSetterBiConsumers.put(
				"uuid",
				(BiConsumer<DepotEntryPin, String>)DepotEntryPin::setUuid);
			attributeSetterBiConsumers.put(
				"depotEntryPinId",
				(BiConsumer<DepotEntryPin, Long>)
					DepotEntryPin::setDepotEntryPinId);
			attributeSetterBiConsumers.put(
				"groupId",
				(BiConsumer<DepotEntryPin, Long>)DepotEntryPin::setGroupId);
			attributeSetterBiConsumers.put(
				"companyId",
				(BiConsumer<DepotEntryPin, Long>)DepotEntryPin::setCompanyId);
			attributeSetterBiConsumers.put(
				"userId",
				(BiConsumer<DepotEntryPin, Long>)DepotEntryPin::setUserId);
			attributeSetterBiConsumers.put(
				"depotEntryId",
				(BiConsumer<DepotEntryPin, Long>)
					DepotEntryPin::setDepotEntryId);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public long getCtCollectionId() {
		return _ctCollectionId;
	}

	@Override
	public void setCtCollectionId(long ctCollectionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_ctCollectionId = ctCollectionId;
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@JSON
	@Override
	public long getDepotEntryPinId() {
		return _depotEntryPinId;
	}

	@Override
	public void setDepotEntryPinId(long depotEntryPinId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_depotEntryPinId = depotEntryPinId;
	}

	@JSON
	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_groupId = groupId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalGroupId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("groupId"));
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalUserId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("userId"));
	}

	@JSON
	@Override
	public long getDepotEntryId() {
		return _depotEntryId;
	}

	@Override
	public void setDepotEntryId(long depotEntryId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_depotEntryId = depotEntryId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalDepotEntryId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("depotEntryId"));
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), DepotEntryPin.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public DepotEntryPin toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, DepotEntryPin>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		DepotEntryPinImpl depotEntryPinImpl = new DepotEntryPinImpl();

		depotEntryPinImpl.setMvccVersion(getMvccVersion());
		depotEntryPinImpl.setCtCollectionId(getCtCollectionId());
		depotEntryPinImpl.setUuid(getUuid());
		depotEntryPinImpl.setDepotEntryPinId(getDepotEntryPinId());
		depotEntryPinImpl.setGroupId(getGroupId());
		depotEntryPinImpl.setCompanyId(getCompanyId());
		depotEntryPinImpl.setUserId(getUserId());
		depotEntryPinImpl.setDepotEntryId(getDepotEntryId());

		depotEntryPinImpl.resetOriginalValues();

		return depotEntryPinImpl;
	}

	@Override
	public DepotEntryPin cloneWithOriginalValues() {
		DepotEntryPinImpl depotEntryPinImpl = new DepotEntryPinImpl();

		depotEntryPinImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		depotEntryPinImpl.setCtCollectionId(
			this.<Long>getColumnOriginalValue("ctCollectionId"));
		depotEntryPinImpl.setUuid(this.<String>getColumnOriginalValue("uuid_"));
		depotEntryPinImpl.setDepotEntryPinId(
			this.<Long>getColumnOriginalValue("depotEntryPinId"));
		depotEntryPinImpl.setGroupId(
			this.<Long>getColumnOriginalValue("groupId"));
		depotEntryPinImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		depotEntryPinImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		depotEntryPinImpl.setDepotEntryId(
			this.<Long>getColumnOriginalValue("depotEntryId"));

		return depotEntryPinImpl;
	}

	@Override
	public int compareTo(DepotEntryPin depotEntryPin) {
		long primaryKey = depotEntryPin.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof DepotEntryPin)) {
			return false;
		}

		DepotEntryPin depotEntryPin = (DepotEntryPin)object;

		long primaryKey = depotEntryPin.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<DepotEntryPin> toCacheModel() {
		DepotEntryPinCacheModel depotEntryPinCacheModel =
			new DepotEntryPinCacheModel();

		depotEntryPinCacheModel.mvccVersion = getMvccVersion();

		depotEntryPinCacheModel.ctCollectionId = getCtCollectionId();

		depotEntryPinCacheModel.uuid = getUuid();

		String uuid = depotEntryPinCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			depotEntryPinCacheModel.uuid = null;
		}

		depotEntryPinCacheModel.depotEntryPinId = getDepotEntryPinId();

		depotEntryPinCacheModel.groupId = getGroupId();

		depotEntryPinCacheModel.companyId = getCompanyId();

		depotEntryPinCacheModel.userId = getUserId();

		depotEntryPinCacheModel.depotEntryId = getDepotEntryId();

		return depotEntryPinCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<DepotEntryPin, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<DepotEntryPin, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<DepotEntryPin, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply((DepotEntryPin)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, DepotEntryPin>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					DepotEntryPin.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private long _ctCollectionId;
	private String _uuid;
	private long _depotEntryPinId;
	private long _groupId;
	private long _companyId;
	private long _userId;
	private long _depotEntryId;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<DepotEntryPin, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((DepotEntryPin)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("ctCollectionId", _ctCollectionId);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put("depotEntryPinId", _depotEntryPinId);
		_columnOriginalValues.put("groupId", _groupId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("depotEntryId", _depotEntryId);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("ctCollectionId", 2L);

		columnBitmasks.put("uuid_", 4L);

		columnBitmasks.put("depotEntryPinId", 8L);

		columnBitmasks.put("groupId", 16L);

		columnBitmasks.put("companyId", 32L);

		columnBitmasks.put("userId", 64L);

		columnBitmasks.put("depotEntryId", 128L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private DepotEntryPin _escapedModel;

}