/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.depot.service.impl;

import com.liferay.depot.model.DepotEntry;
import com.liferay.depot.model.DepotEntryGroupRel;
import com.liferay.depot.service.base.DepotEntryGroupRelServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(property={"json.web.service.context.name=depot", "json.web.service.context.path=DepotEntryGroupRel"}, service={AopService.class})
public class DepotEntryGroupRelServiceImpl
extends DepotEntryGroupRelServiceBaseImpl {
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(model.class.name=com.liferay.depot.model.DepotEntry)")
    private volatile ModelResourcePermission<DepotEntry> _depotEntryModelResourcePermission;

    public DepotEntryGroupRel addDepotEntryGroupRel(long depotEntryId, long toGroupId) throws PortalException {
        this._depotEntryModelResourcePermission.check(this.getPermissionChecker(), depotEntryId, "UPDATE");
        return this.depotEntryGroupRelLocalService.addDepotEntryGroupRel(depotEntryId, toGroupId);
    }

    public DepotEntryGroupRel deleteDepotEntryGroupRel(long depotEntryGroupRelId) throws PortalException {
        DepotEntryGroupRel depotEntryGroupRel = this.depotEntryGroupRelLocalService.getDepotEntryGroupRel(depotEntryGroupRelId);
        this._depotEntryModelResourcePermission.check(this.getPermissionChecker(), depotEntryGroupRel.getDepotEntryId(), "UPDATE");
        return this.depotEntryGroupRelLocalService.deleteDepotEntryGroupRel(depotEntryGroupRel);
    }

    public DepotEntryGroupRel getDepotEntryGroupRelByDepotEntryIdToGroupId(long depotEntryId, long toGroupId) throws PortalException {
        this._depotEntryModelResourcePermission.check(this.getPermissionChecker(), depotEntryId, "VIEW");
        return this.depotEntryGroupRelLocalService.getDepotEntryGroupRelByDepotEntryIdToGroupId(depotEntryId, toGroupId);
    }

    public List<DepotEntryGroupRel> getDepotEntryGroupRels(DepotEntry depotEntry, int start, int end) throws PortalException {
        this._depotEntryModelResourcePermission.check(this.getPermissionChecker(), depotEntry.getDepotEntryId(), "VIEW");
        return this.depotEntryGroupRelLocalService.getDepotEntryGroupRels(depotEntry, start, end);
    }

    public List<DepotEntryGroupRel> getDepotEntryGroupRels(long groupId, int type, int start, int end) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"VIEW");
        return this.depotEntryGroupRelLocalService.getDepotEntryGroupRels(groupId, type, start, end);
    }

    public int getDepotEntryGroupRelsCount(DepotEntry depotEntry) throws PortalException {
        this._depotEntryModelResourcePermission.check(this.getPermissionChecker(), depotEntry.getDepotEntryId(), "VIEW");
        return this.depotEntryGroupRelLocalService.getDepotEntryGroupRelsCount(depotEntry);
    }

    public int getDepotEntryGroupRelsCount(long groupId, int type) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"VIEW");
        return this.depotEntryGroupRelLocalService.getDepotEntryGroupRelsCount(groupId, type);
    }

    public DepotEntryGroupRel updateDDMStructuresAvailable(long depotEntryGroupRelId, boolean ddmStructuresAvailable) throws PortalException {
        DepotEntryGroupRel depotEntryGroupRel = this.depotEntryGroupRelLocalService.getDepotEntryGroupRel(depotEntryGroupRelId);
        this._depotEntryModelResourcePermission.check(this.getPermissionChecker(), depotEntryGroupRel.getDepotEntryId(), "UPDATE");
        return this.depotEntryGroupRelLocalService.updateDDMStructuresAvailable(depotEntryGroupRelId, ddmStructuresAvailable);
    }

    public DepotEntryGroupRel updateSearchable(long depotEntryGroupRelId, boolean searchable) throws PortalException {
        DepotEntryGroupRel depotEntryGroupRel = this.depotEntryGroupRelLocalService.getDepotEntryGroupRel(depotEntryGroupRelId);
        this._depotEntryModelResourcePermission.check(this.getPermissionChecker(), depotEntryGroupRel.getDepotEntryId(), "UPDATE");
        return this.depotEntryGroupRelLocalService.updateSearchable(depotEntryGroupRelId, searchable);
    }
}

