/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.depot.service.impl;

import com.liferay.depot.model.DepotAppCustomization;
import com.liferay.depot.model.DepotEntry;
import com.liferay.depot.service.base.DepotAppCustomizationLocalServiceBaseImpl;
import com.liferay.depot.service.persistence.DepotEntryPersistence;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.depot.model.DepotAppCustomization"}, service={AopService.class})
public class DepotAppCustomizationLocalServiceImpl
extends DepotAppCustomizationLocalServiceBaseImpl {
    @Reference
    private DepotEntryPersistence _depotEntryPersistence;

    public DepotAppCustomization fetchDepotAppCustomization(long depotEntryId, String portletId) {
        return this.depotAppCustomizationPersistence.fetchByD_P(depotEntryId, portletId);
    }

    public List<DepotAppCustomization> getDepotAppCustomizations(long depotEntryId) {
        return this.depotAppCustomizationPersistence.findByDepotEntryId(depotEntryId);
    }

    public int getDepotAppCustomizationsCount(long depotEntryId, boolean enabled) {
        return this.depotAppCustomizationPersistence.countByD_E(depotEntryId, enabled);
    }

    public DepotAppCustomization updateDepotAppCustomization(long depotEntryId, boolean enabled, String portletId) throws PortalException {
        DepotAppCustomization depotAppCustomization = this.depotAppCustomizationPersistence.fetchByD_P(depotEntryId, portletId);
        if (depotAppCustomization == null) {
            return this._addDepotAppCustomization(depotEntryId, enabled, portletId);
        }
        depotAppCustomization.setEnabled(enabled);
        return (DepotAppCustomization)this.depotAppCustomizationPersistence.update((BaseModel)depotAppCustomization);
    }

    private DepotAppCustomization _addDepotAppCustomization(long depotEntryId, boolean enabled, String portletId) throws PortalException {
        DepotAppCustomization depotAppCustomization = this.depotAppCustomizationPersistence.create(this.counterLocalService.increment());
        DepotEntry depotEntry = this._depotEntryPersistence.findByPrimaryKey(depotEntryId);
        depotAppCustomization.setCompanyId(depotEntry.getCompanyId());
        depotAppCustomization.setDepotEntryId(depotEntryId);
        depotAppCustomization.setEnabled(enabled);
        depotAppCustomization.setPortletId(portletId);
        return (DepotAppCustomization)this.depotAppCustomizationPersistence.update((BaseModel)depotAppCustomization);
    }
}

