/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.depot.internal.security.permission.contributor;

import com.liferay.depot.model.DepotEntryGroupRel;
import com.liferay.depot.service.DepotEntryGroupRelLocalService;
import com.liferay.depot.service.DepotEntryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.security.permission.UserBag;
import com.liferay.portal.kernel.security.permission.contributor.RoleCollection;
import com.liferay.portal.kernel.security.permission.contributor.RoleContributor;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.UserGroupLocalService;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={RoleContributor.class})
public class DepotRoleContributor
implements RoleContributor {
    private static final Log _log = LogFactoryUtil.getLog(DepotRoleContributor.class);
    @Reference
    private DepotEntryGroupRelLocalService _depotEntryGroupRelLocalService;
    @Reference
    private DepotEntryLocalService _depotEntryLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private OrganizationLocalService _organizationLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private UserGroupLocalService _userGroupLocalService;

    public void contribute(RoleCollection roleCollection) {
        try {
            if (roleCollection.getGroupId() <= 0L) {
                return;
            }
            Group group = this._groupLocalService.getGroup(roleCollection.getGroupId());
            if (group.isDepot()) {
                UserBag userBag = roleCollection.getUserBag();
                if (userBag.hasUserGroup(group) || this._hasInheritedMemberships(group.getGroupId(), userBag)) {
                    this._addRoleId(roleCollection, "Asset Library Member");
                }
                List depotEntryGroupRels = this._depotEntryGroupRelLocalService.getDepotEntryGroupRels(this._depotEntryLocalService.getGroupDepotEntry(group.getGroupId()));
                for (DepotEntryGroupRel depotEntryGroupRel : depotEntryGroupRels) {
                    if (!userBag.hasUserGroup(this._groupLocalService.getGroup(depotEntryGroupRel.getToGroupId()))) continue;
                    this._addRoleId(roleCollection, "Asset Library Connected Site Member");
                    break;
                }
            }
            if (FeatureFlagManagerUtil.isEnabled((long)group.getCompanyId(), (String)"LPD-17564") && group.isCMS()) {
                this._addRoleId(roleCollection, "CMS Consumer");
            }
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
        }
    }

    private void _addRoleId(RoleCollection roleCollection, String roleName) throws PortalException {
        Role role = this._roleLocalService.getRole(roleCollection.getCompanyId(), roleName);
        roleCollection.addRoleId(role.getRoleId());
    }

    private boolean _hasInheritedMemberships(long groupId, UserBag userBag) {
        List organizations = this._organizationLocalService.getGroupOrganizations(groupId);
        for (Organization organization : organizations) {
            if (!userBag.hasUserOrg(organization)) continue;
            return true;
        }
        List groupUserGroups = this._userGroupLocalService.getGroupUserGroups(groupId);
        List userUserGroups = this._userGroupLocalService.getUserUserGroups(userBag.getUserId());
        for (UserGroup groupUserGroup : groupUserGroups) {
            if (!userUserGroups.contains(groupUserGroup)) continue;
            return true;
        }
        return false;
    }
}

