/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.depot.service.impl;

import com.liferay.depot.model.DepotEntry;
import com.liferay.depot.model.DepotEntryPin;
import com.liferay.depot.service.base.DepotEntryPinLocalServiceBaseImpl;
import com.liferay.depot.service.persistence.DepotEntryPersistence;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.depot.model.DepotEntryPin"}, service={AopService.class})
public class DepotEntryPinLocalServiceImpl
extends DepotEntryPinLocalServiceBaseImpl {
    @Reference
    private DepotEntryPersistence _depotEntryPersistence;
    @Reference
    private UserLocalService _userLocalService;

    public DepotEntryPin addDepotEntryPin(long userId, long depotEntryId) throws PortalException {
        DepotEntryPin depotEntryPin = this.depotEntryPinPersistence.create(this.counterLocalService.increment());
        DepotEntry depotEntry = this._depotEntryPersistence.findByPrimaryKey(depotEntryId);
        depotEntryPin.setGroupId(depotEntry.getGroupId());
        User user = this._userLocalService.getUser(userId);
        depotEntryPin.setCompanyId(user.getCompanyId());
        depotEntryPin.setUserId(userId);
        depotEntryPin.setDepotEntryId(depotEntryId);
        return (DepotEntryPin)this.depotEntryPinPersistence.update((BaseModel)depotEntryPin);
    }

    public void deleteDepotEntryDepotEntryPins(long depotEntryId) {
        this.depotEntryPinPersistence.removeByDepotEntryId(depotEntryId);
    }

    public DepotEntryPin deleteDepotEntryPin(long userId, long depotEntryId) throws PortalException {
        return this.depotEntryPinPersistence.removeByU_D(userId, depotEntryId);
    }

    public void deleteUserDepotEntryPins(long userId) {
        this.depotEntryPinPersistence.removeByUserId(userId);
    }

    public List<DepotEntryPin> getDepotEntryDepotEntryPins(long depotEntryId, int start, int end) {
        return this.depotEntryPinPersistence.findByDepotEntryId(depotEntryId, start, end);
    }

    public int getDepotEntryDepotEntryPinsCount(long depotEntryId) {
        return this.depotEntryPinPersistence.countByDepotEntryId(depotEntryId);
    }

    public DepotEntryPin getDepotEntryPin(long userId, long depotEntryId) throws PortalException {
        return this.depotEntryPinPersistence.fetchByU_D(userId, depotEntryId);
    }

    public List<DepotEntryPin> getUserDepotEntryPins(long userId, int start, int end) {
        return this.depotEntryPinPersistence.findByUserId(userId, start, end);
    }

    public int getUserDepotEntryPinsCount(long userId) {
        return this.depotEntryPinPersistence.countByUserId(userId);
    }
}

